/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jEgM
 */

package {
    import flash.events.*;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.geom.*;
    public class FlashTest extends Sprite {
        private var txt:TextField;
        public function FlashTest() {
            if(stage==null)this.addEventListener(Event.ADDED_TO_STAGE,init);
            else init(null);
        }
        
        private function addPoint(x:Number=0,y:Number=0,col:uint=0x000000):void{
            var p1:Point2 = new Point2(x,y,col);
            addChild(p1);
            p[p1.id]=p1;
            
        }

        
        private function init(e:Event):void{
            
            
            txt = new TextField;
            txt.selectable = false;
            addChild(txt);
            txt.width = 400;
            txt.height = 300;
            txt.text = "test";
            addEventListener(Event.ENTER_FRAME,onFrame); 
            
            
            
            addPoint();//0
            addPoint(200,200,0xff0000);//1
            addPoint(300,300);//2
            addPoint(100,300);//3
            addPoint(100,100);//4
            
            addPoint(200,300);//5
            addPoint(200,100);//6
            addPoint(200,400);//7
            //addPoint(200,100);//8 
            addLine(p[0],p[4],0x0000ff);
            addLine(p[3],p[4],0xff0000);
            addLine(p[0],p[3]);
            addVector(p[2],p[4],0x00ff00);
            //p[3].text = "A";
            //p[2].text = "H";
            
        }
        private function drawLine(p1:Point2,p2:Point2,col:uint=0x000000):void{
            graphics.lineStyle(0,col);
            graphics.moveTo(p1.x,p1.y);
            graphics.lineTo(p2.x,p2.y);
        }
        private function drawVector(p1:Point2,p2:Point2,col:uint=0x000000):void{
            graphics.lineStyle(0,col);
            graphics.moveTo(p1.x,p1.y);
            graphics.lineTo(p2.x,p2.y);
            var a:Number = angle(p1,p2);//ベクトルの角度
            var b:Number = distance(p1,p2);//ベクトルの長さ
            const c:Number = 0.9;//矢印の角度
            const d:Number = 0.1;//矢印の大きさ
            var x3:Number = Math.cos(a-Math.PI*c)*(b*d);
            var y3:Number = Math.sin(a-Math.PI*c)*(b*d);
            graphics.lineTo(p2.x+x3,p2.y+y3);
            graphics.moveTo(p2.x,p2.y);            
            x3 = Math.cos(a+Math.PI*c)*(b*d);
            y3 = Math.sin(a+Math.PI*c)*(b*d);
            graphics.lineTo(p2.x+x3,p2.y+y3);
            
        }

        private const LINE:int = 0;
        private const VECTOR:int = 1;
        private var lineList:Array = new Array();
        //表示する線を登録
        private function addLine(p1:Point2,p2:Point2,col:uint=0x000000):void{
            var line:Array = new Array();
            line[0] = p1;
            line[1] = p2;
            line[2] = col;
            line[3] = LINE;
            lineList[lineList.length]=line;
        }
        //ベクトル登録
        private function addVector(p1:Point2,p2:Point2,col:uint=0x000000):void{
            var line:Array = new Array();
            line[0] = p1;
            line[1] = p2;
            line[2] = col;
            line[3] = VECTOR;
            lineList[lineList.length]=line;
        }
        
        //登録された線をまとめて描画
        private function drawLines():void{
            for(var i:int=0;i<lineList.length;i++){
                var line:Array = lineList[i]; 
                var p1:Point2 = line[0];
                var p2:Point2 = line[1];
                var col:uint = line[2];
                switch(line[3]){
                    case LINE:
                        drawLine(p1,p2,col);
                        break;
                    case VECTOR:
                        drawVector(p1,p2,col);
                        break;
                }
            }

        }
        private function distance(p1:Point2, p2:Point2):Number{
            var disx:Number = p2.x - p1.x;
            var disy:Number = p2.y - p1.y;
            var p:Point = new Point(disx,disy);
            var dis:Number = Math.sqrt(disx*disx + disy*disy);
            return Math.abs(dis);
        }

        private function drawAngle(p1:Point2,p2:Point2,p3:Point2,col:uint=0x000000):void{
            //角度表示サイズを決める
            var n1:Number = distance(p1,p2);
            var n2:Number = distance(p2,p3);
            
            
            //辺の角度を求める
            var a:Number = angle(p1,p2);
            var b:Number = angle(p2,p3);
            var c:Number;
            if(Math.PI < b-a)c = Math.PI*0.5;
            else c = -Math.PI*0.5;

            
            graphics.lineStyle(0,col);
            graphics.moveTo(p1.x,p1.y);
            graphics.lineTo(p2.x,p2.y);
        }
        
        
        private function angle(p1:Point2,p2:Point2):Number{
            var a:Number = p2.x - p1.x;
            var b:Number = p2.y - p1.y;
            var c:Number = Math.atan2(b,a);
            if(c<0)c+= Math.PI*2;
            txt.appendText("\n["+p1.text+"->"+p2.text+"] "+c.toString());
            return c;
        }
        
        private function drawAngle2(x:Number, y:Number, rad:Number, col:uint):void{
            var r:Number=10;
            graphics.lineStyle(0,col);
            graphics.moveTo(x,y);
            graphics.lineTo(x+Math.cos(rad)*r,y+Math.sin(rad)*r);
        }





        private var rad:Number=0;
        private var cnt:int=0;
        private var p:Object = new Object();
        private function onFrame(event:Event):void{
            cnt++;
            rad = Math.PI /180 *cnt;
            var r:Number = 100;
            var x:Number = Math.cos(rad);
            
            
            txt.text = x.toString();
            
            graphics.clear();
            graphics.lineStyle(0,0xaaaaaa);
            graphics.drawCircle(p[1].x,p[1].y,r);
            
            //rad %= Math.PI;
            var x3:Number = Math.cos(rad)*r;
            var y3:Number = Math.sin(rad)*r;
            
            
            p[0].x = p[1].x+r;
            p[0].y = p[1].y;
            
            p[2].x = p[1].x + Math.cos(rad)*r;
            p[2].y = p[1].x;
            
            p[3].x = p[1].x-r;
            p[3].y = p[1].y;

            p[4].x = p[1].x+x3;
            p[4].y = p[1].y+y3;
            /*
            //辺の角度を求める
            var a:Number = angle(p[0],p[4]);
            var b:Number = angle(p[4],p[3]);
            var c:Number = distance(p[0],p[4]);
            var d:Number = distance(p[4],p[3]);
            var e:Number;
            const f:Number = 0.15;
            if(c<d)e = c*f;
            else e = d*f;
            
            p[5].x = p[4].x+Math.cos(a+Math.PI)*e;
            p[5].y = p[4].y+Math.sin(a+Math.PI)*e;

            p[6].x = p[4].x-Math.cos(b+Math.PI)*e;
            p[6].y = p[4].y-Math.sin(b+Math.PI)*e;
            */
            //p[7].x = p[5].x+Math.cos(a+Math.PI/2)*e;
            //p[7].y = p[5].y+Math.sin(a+Math.PI/2)*e;


            
            //if(Math.PI < b-a)c = Math.PI*0.5;
            //else c = -Math.PI*0.5;


            var ax2:Number = 150;
            var ay2:Number = 0;
            var ax:Number = 0;//x2+x3;
            var ay:Number = -r;//y2+y3;
            ax = Math.cos(rad)*ax2 -Math.sin(rad)*ay2;
            ay = Math.sin(rad)*ax2 +Math.cos(rad)*ay2; 
            //p[5].x = p[1].x+ax;
            //p[5].y =p[1].y+ay;
            
            //回転後X = cos(rot)*元x - sin(rot)*元y;
            //回転後Y = sin(rot)*元x + cos(rot)*元y

            drawLines();
            angle(p[1],p[4]);
            angle(p[4],p[1]);
            angle(p[1],p[2]);
        }

    }
}
import flash.text.TextField;
import flash.display.*;
import flash.events.*;

class Point2 extends Sprite{
    private var tytle:TextField = new TextField();
    private static var cnt:int=0;
    private var _col:uint;
    private var _id:int;
    private var _origin:Point2;
    public function Point2(x:Number=0,y:Number=0,col:uint=0x000000):void{
        _id = cnt;
        cnt++;
        
        this.x = x;
        this.y = y;
        
        _col=col;
        tytle.y = -20;
        init();
        
    }
    private function init(e:Event=null):void{
        this.removeEventListener(Event.ADDED_TO_STAGE,init);
        tytle.text = _id.toString();
        tytle.selectable = false;
        this.addChild(tytle);
        draw();
        
    }

    public function draw(col:uint=0x000000):void{
        if(col!=0x000000)_col = col;
        this.graphics.clear();
        this.graphics.lineStyle(0,_col);
        this.graphics.drawCircle(0,0,3);
    }
    public function set text(n:String):void{
        tytle.text = n;
    }
    public function get text():String{
        return tytle.text;
    }

    public function get id():int{
        return _id;
    }
    public function set origin(o:Point2):void{
        _origin = o;
        
    }
    
    private var _x:Number;
    private var _y:Number;
    public function get X():Number{
        if(_origin==null)return _x;
        return _x+_origin.Y;
    }
    public function get Y():Number{
        if(_origin==null)return _y;
        return _y+_origin.Y;
    }
    public function set X(n:Number):void{
        _x = n;
        this.x = this.X;
    }
    public function set Y(n:Number):void{
        _y = n;
        this.y = this.Y;
    }







}

