/**
 * Copyright yamadori ( http://wonderfl.net/user/yamadori )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jEP6
 */

package
{
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.net.FileReference;
    import flash.events.MouseEvent;
    import flash.net.FileFilter;
    import flash.display.Bitmap;
    
    import com.bit101.components.PushButton;

    public class Main extends Sprite
    {
        private var fileLoader:FileLoader;
        private var button:PushButton
        
        public function Main()
        {
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            
            fileLoader = new FileLoader();
            fileLoader.addEventListener(Event.INIT, initHandler);
            
            button = new PushButton(this, 0, 0, "LOAD", load);
            button.scaleX = button.scaleY = 1;
            button.x = stage.stageWidth/2 - button.width/2;
            button.y = stage.stageHeight/2 - button.height/2;
        }
        
        private function load(e:Event = null):void
        {
            fileLoader.browse();
        }
        
        private function initHandler(e:Event):void
        {
            var loader:Loader = e.currentTarget.loader;
            var board:Board = new Board(loader.content as Bitmap);
            addChild(board);
            board.x = 20;
            board.y = 20;
            
            removeChild(button);
        }
    }
}
import flash.display.Sprite;
import flash.filters.BevelFilter;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.events.MouseEvent;
import frocessing.math.Random;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class Board extends Sprite
{
    public static const WIDTH:int = 5;
    public static const HEIGHT:int = 5;
    
    private var tiles:Array;
    private var clickable:Boolean;
    private var playable:Boolean;
    
    public function Board(source:Bitmap)
    {
        // サイズ調整
        var baseBd:BitmapData = new BitmapData(WIDTH*Tile.SIZE, HEIGHT*Tile.SIZE);
        var mat:Matrix = new Matrix();
        var s:Number;
        var dx:Number = 0;
        var dy:Number = 0;
        if(source.width < source.height)
        {
            s = WIDTH*Tile.SIZE/source.width;
            dy = -(source.height*s-baseBd.height)/2;
        }
        else
        {
            s = HEIGHT*Tile.SIZE/source.height;
            dx = -(source.width*s-baseBd.width)/2;
        }
        mat.scale(s, s);
        mat.translate(dx, dy);
        baseBd.draw(source, mat);
        //
        
        playable = false;
        
        graphics.beginFill(0xC0C0C0);
        graphics.drawRect(0,0,Tile.SIZE*WIDTH, Tile.SIZE*HEIGHT);
        
        tiles = [];
        for(var i:int = 0; i<HEIGHT; i++)
        {
            tiles[i] = [];
            for(var j:int = 0; j<WIDTH; j++)
            {
                if(!(i == WIDTH-1 && j == HEIGHT-1))
                {
                    var bd:BitmapData = new BitmapData(Tile.SIZE, Tile.SIZE);
                    bd.copyPixels(baseBd, new Rectangle(j*Tile.SIZE, i*Tile.SIZE, Tile.SIZE, Tile.SIZE), new Point());
                    
                    var tile:Tile = new Tile(i*WIDTH+(j+1), bd);
                    tile.x = j*Tile.SIZE;
                    tile.y = i*Tile.SIZE;
                    addChild(tile);
                    tiles[i][j] = tile;
                }
            }
        }
        shuffle(WIDTH*HEIGHT*6);
        
        playable = true;
        clickable = true;
        
        addEventListener(MouseEvent.CLICK, onClick);
    }
    
    private function onClick(e:MouseEvent):void
    {
        if(!clickable) return;
        
        var tx:int = mouseX/Tile.SIZE;
        var ty:int = mouseY/Tile.SIZE;
        
        if(!onBoard(tx, ty) || tiles[ty][tx] == null) return;
        
        focusTarget(tx,ty)
        
        if(checkCorrect()) trace("GAME CLEAR!");
    }
    
    private function onBoard(x:int, y:int):Boolean
    {
        if(x<0 || Board.WIDTH<=x || y<0 || Board.HEIGHT<=y) return false;
        return true;
    }
    
    private function focusTarget(x:int, y:int):void
    {
        if(searchSpace(x, y-1)) changePosition(x, y, x, y-1);
        if(searchSpace(x+1, y)) changePosition(x, y, x+1, y);
        if(searchSpace(x, y+1)) changePosition(x, y, x, y+1);
        if(searchSpace(x-1, y)) changePosition(x, y, x-1, y);
    }
    
    private function searchSpace(x:int, y:int):Boolean
    {
        if(!onBoard(x, y)) return false;
        if(tiles[y][x] == null) return true;
        return false;
    }
    
    private function changePosition(x:int, y:int, tx:int, ty:int):void
    {
        clickable = false;
        
        if(playable)
        {
            var t:ITween = BetweenAS3.tween(tiles[y][x], {x:tx*Tile.SIZE, y:ty*Tile.SIZE}, null, 0.2);
            t.play();
            t.onComplete = onComplete;
        }
        else
        {
            tiles[y][x].x = tx*Tile.SIZE;
            tiles[y][x].y = ty*Tile.SIZE;
        }
        tiles[ty][tx] = tiles[y][x];
        tiles[y][x] = null;
    }
    
    private function shuffle(times:int):void
    {
        const DIR:Array = [
                           [0, -1],
                           [1, 0],
                           [0, 1],
                           [-1, 0],
                          ];
        var x:int = WIDTH-1;
        var y:int = HEIGHT-1;
        
        for(var i:int = 0; i<50; i++) {
            
            var random:Array = Random.shakedIntegers(4);
            
            for(var j:int = 0; j<random.length; j++)
            {
                var dx:int = DIR[random[j]][0];
                var dy:int = DIR[random[j]][1];
                
                if(!onBoard(x+dx, y+dy)) continue;
                changePosition(x+dx, y+dy, x, y);
                x = x+dx;
                y = y+dy;
                break;
            }
        }
    }
    
    private function checkCorrect():Boolean
    {
        if(!(tiles[HEIGHT-1][WIDTH-1] == null)) return false;
        for(var i:int = 0; i<HEIGHT; i++)
        {
            for(var j:int = 0; j<WIDTH; j++)
            {
                if(i == HEIGHT-1 && j == WIDTH-1) continue;
                if(!(tiles[i][j].number == i*WIDTH+(j+1))) return false;
            }
        }
        return true;
    }
    
    private function onComplete():void
    {
        clickable = true;
    }
}
class Tile extends Sprite
{
    public static const SIZE:int = 70;
    public var number:int;
    
    public function Tile(number:int, bd:BitmapData)
    {
        this.number = number;
        
        graphics.beginFill(0x808080);
        graphics.drawRect(0, 0, SIZE, SIZE);
        graphics.endFill();
        
        addChild(new Bitmap(bd));
    }
}
import flash.events.EventDispatcher;
    import flash.net.FileReference;
    import flash.events.Event;
    import flash.net.FileFilter;
    import flash.display.Loader;
    import flash.display.BitmapData;
    import flash.display.Bitmap;

    class FileLoader extends EventDispatcher
    {
        public var loader:Loader;
        
        private var fileReference:FileReference;
        
        public function FileLoader()
        {
            fileReference = new FileReference;
            fileReference.addEventListener(Event.SELECT, selectHandler);
            fileReference.addEventListener(Event.CANCEL, cancelHandler);
            fileReference.addEventListener(Event.COMPLETE, completeHandler);
        }
        
        public function browse():void
        {
            var fileFilter:FileFilter = new FileFilter("Image(JPEG, GIF, PNG)", "*.jpg;*.gif;*.png");
            fileReference.browse([fileFilter]);
        }
        
        private function selectHandler(e:Event):void
        {
            fileReference.load();
        }
        
        private function cancelHandler(e:Event):void
        {
            dispatchEvent(new Event(Event.CANCEL));
        }
        
        private function completeHandler(e:Event):void
        {
            loader = new Loader();
            loader.loadBytes(fileReference.data);
            loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
        }
        
        private function initHandler(e:Event):void
        {
            loader = e.currentTarget.loader;
            
            dispatchEvent(new Event(Event.INIT));
        }
    }