/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jEBL
 */

// モーショングラフィックス的なイメージで作ってみた。
// 
// マウスについてきます。
// 
// プログラムで書くと苦労するけど、トゥイーンとかで作っても苦労するんだろう。
// ランダムにできる分プログラムで作ったものの方が見てて楽しいと思う。
// 
package {
    import flash.display.Sprite;
	import flash.events.Event;
    public class FlashTest extends Sprite
	{
		private var redLine:Line;
		private var greenLine:Line;
		private var blueLine:Line;
		private var purpleLine:Line;
		
        public function FlashTest()
		{
			redLine = new Line();
			addChild(redLine);
			redLine.color = 0xFF0000;
			
			greenLine = new Line();
			addChild(greenLine);
			greenLine.color = 0x00FF00;
			
			blueLine = new Line();
			addChild(blueLine);
			blueLine.color = 0x0000FF;
			
			purpleLine = new Line();
			addChild(purpleLine);
			purpleLine.color = 0xFF00FF;
			
			addEventListener(Event.ENTER_FRAME, update);
        }
		
		private var angle:Number = 0;
		private function update(e:Event):void
		{
			angle += (5 * Math.PI / 180) % (Math.PI * 2);
			redLine.targetPoint.x = mouseX+Math.cos(angle) * 120;
			redLine.targetPoint.y = mouseY+Math.sin(angle) * 120;
			greenLine.targetPoint.x = mouseX+Math.cos(angle+Math.PI*.5) * 120;
			greenLine.targetPoint.y = mouseY+Math.sin(angle+Math.PI*.5) * 120;
			blueLine.targetPoint.x = mouseX+Math.cos(angle+Math.PI) * 120;
			blueLine.targetPoint.y = mouseY+Math.sin(angle+Math.PI) * 120;
			purpleLine.targetPoint.x = mouseX+Math.cos(angle+Math.PI*1.5) * 120;
			purpleLine.targetPoint.y = mouseY+Math.sin(angle+Math.PI*1.5) * 120;
			
			if (Math.random() < .5)
			{
				var star:Sprite = new Sprite();
				addChild(star);
				switch(int(Math.random() * 4))
				{
				case 0:
					star.x = redLine.x + redLine.headPoint.x;
					star.y = redLine.y + redLine.headPoint.y;
					star.graphics.beginFill(0xFF0000);
					break;
				case 1:
					star.x = greenLine.x + greenLine.headPoint.x;
					star.y = greenLine.y + greenLine.headPoint.y;
					star.graphics.beginFill(0x00FF00);
					break;
				case 2:
					star.x = blueLine.x + blueLine.headPoint.x;
					star.y = blueLine.y + blueLine.headPoint.y;
					star.graphics.beginFill(0x0000FF);
					break;
				default:
					star.x = purpleLine.x + purpleLine.headPoint.x;
					star.y = purpleLine.y + purpleLine.headPoint.y;
					star.graphics.beginFill(0xFF00FF);
					break;
				}
				star.graphics.moveTo(20, 0);
				for (var i:int = 0; i < 5; i++)
				{
					var a:Number = i / 5 * Math.PI * 2;
					star.graphics.lineTo(Math.cos(a) * 20, Math.sin(a) * 20);
					star.graphics.lineTo(Math.cos(a+Math.PI/5) * 12, Math.sin(a+Math.PI/5) * 12);
				}
				star.graphics.endFill();
				star.rotation = Math.random() * 360;
				var dir:Number = (Math.random() - .5) * Math.PI*.5;
				var count:Number = 0;
				star.addEventListener(Event.ENTER_FRAME, function(e:Event):void
				{
					if (count > 20 && star.x < 0) {
						removeChild(star);
						star.removeEventListener(Event.ENTER_FRAME, arguments.callee);
						return;
					}
					else
					{
						count++;
					}
					star.x += Math.cos(dir) * (20 - count)*2 - 20;
					star.y += Math.sin(dir) * (20 - count)*2;
				});
			}
		}
		
    }
}

import flash.display.Sprite
import flash.events.Event;
class Line extends Sprite
{
	private var linePointList:Array;
	private var scrollSpeed:Number = 20;
	private var _color:uint = 0x000000;
	private var _headPoint:Object;
	private var _targetPoint:Object;
	
	public function Line()
	{
		super();
		
		linePointList = new Array();
		for (var i:int = 0; i < 20; i++)
		{
			linePointList.push( { x:0, y:0 } );
		}
		_headPoint = { x:0, y:0 };
		_targetPoint = { x:0, y:0 };
		
		addEventListener(Event.ENTER_FRAME, update);
	}
	
	private function update(e:Event):void 
	{
		graphics.clear();
		
		linePointList.pop();
		
		var angle:Number = Math.atan2(_targetPoint.y - _headPoint.y, _targetPoint.x - _headPoint.x) + (Math.random() - .5) * Math.PI*.5;
		headPoint.x += Math.cos(angle) * 5;
		headPoint.y += Math.sin(angle) * 5;
		linePointList.unshift( { x:_headPoint.x, y:_headPoint.y } );
		
		linePointList[0].x -= scrollSpeed;
		graphics.moveTo(linePointList[0].x, linePointList[0].y);
		
		var len:Number = linePointList.length;
		for (var i:int = 1; i < linePointList.length; i++)
		{
			var alpha:Number = (len - i + 1) / (len + 1);
			linePointList[i].x -= scrollSpeed;
			graphics.lineStyle(10, _color, alpha);
			graphics.lineTo(linePointList[i].x, linePointList[i].y);
		}
	}
	
	public function set color(value:uint):void { _color = value; }
	
	public function get headPoint():Object { return _headPoint; }
	
	public function get targetPoint():Object { return _targetPoint; }
	
	public function set targetPoint(value:Object):void { _targetPoint = value; }
}
