/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jD4z
 */

// forked from break's うにょうにょ 最適化と呼びやすくした forked from: ペジェ曲線
// forked from Horiuchi_H's ペジェ曲線
package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	[SWF(width = 465, height = 465, frameRate = 120, backgroundColor = "#0")]
	public class  Main extends Sprite {
		public function Main() {
			this.addEventListener(Event.ADDED, init);
		} 
		
		private function init(e:Event = null):void {
			this.addEventListener(Event.ADDED, init);
			stage.addEventListener(Event.ENTER_FRAME, update);
			var ca:CurveAnimation = new CurveAnimation();
			ca.init(stage);
			
			//うにょうにょの出現率
			const v:uint = 1;
			
			//うにょうにょが曲がる最大の数
			const w:uint = 5;
			
			//曲線の数
			const r:uint = 7;
			
			//幅
			const tn:uint = 5;
			
			function update(e:Event):void {
			    //出現させる方法が粗いので重くなるかもしれません
				if (Math.random() * 100 < v) {
					var p:Vector.<Point> = new Vector.<Point>();
					p.push(new Point(0, 465 * Math.random()));
					var c:uint = Math.floor(Math.random() * w);
					for (var k:uint = 0; k < c; k++) p.push(new Point(465 * Math.random(), 465 * Math.random()));
					p.push(new Point(465, 465 * Math.random()));
					
					
					var colors:Vector.<uint> = new Vector.<uint>();
					for(var i:uint = 0; i< r; i++) colors.push(0xffffff * Math.random() * i);

					/*
					 * 複数のうにょうにょを呼び出します
					 * CurveAnimation#drawRainbow(座標:Vector.<Point>, フレーム数:Number, 色:Vector.<uint>, 曲線の数:uint, 曲線の太さ:uint);
					 */
					ca.drawRainbow(p, 120, colors, r, tn);
				}
			}
		}
	}
}


import flash.display.Sprite;
import flash.display.Graphics;
import flash.display.Stage;
import flash.events.Event;
import flash.geom.Point;
class CurveAnimation {
	private var stage:Stage;
	public function CurveAnimation() {
		
	}
	public function init(_stage:Stage):void {
		stage = _stage;
	}

	public function draw(points:Vector.<Point>, frame:uint, color:uint):void {
		stage.addEventListener(Event.ENTER_FRAME, drawCurve);
		var bee:uint = new uint();
		var s:Sprite = stage.addChild(new Sprite()) as Sprite;
		
		function drawCurve(e:Event = null):void{
			if (bee > frame) {
				stage.removeChild(s);
				stage.removeEventListener(Event.ENTER_FRAME, drawCurve);
			}
			var start:Point = calcBezierCurvePoint(points, bee / frame);
			var end:Point = calcBezierCurvePoint(points, (bee + 1) / frame);
			
			s.graphics.lineStyle(1, color);
			s.graphics.moveTo(start.x, start.y);
			s.graphics.lineTo(end.x, end.y);
			bee++;
		}
	}

	public function drawRainbow(points:Vector.<Point>, frame:uint, colors:Vector.<uint>, r:uint, tn:uint):void {
		stage.addEventListener(Event.ENTER_FRAME, drawCurve);
		var bee:uint = new uint();
		var s:Sprite = stage.addChild(new Sprite()) as Sprite;
		var g:Graphics = s.graphics;
		const k:uint = tn * 2;
		
		function drawCurve(e:Event = null):void{
			if (bee > frame) {
				stage.removeChild(s);
				stage.removeEventListener(Event.ENTER_FRAME, drawCurve);
			}
			
			var start:Point = calcBezierCurvePoint(points, bee / frame);
			var end:Point = calcBezierCurvePoint(points, (bee + 1) / frame);
			
			for (var i:uint = 0; i < r; i++){
				g.lineStyle(tn, colors[i]);
				g.moveTo(start.x, start.y + i * k);
				g.lineTo(end.x, end.y + i * k);
			}
			bee++;
		}
	}
	
	private function calcBezierCurvePoint(points:Vector.<Point>, t:Number):Point {
		var ps:Vector.<Point> = points;
		while (ps.length > 1) {
			var k:Number = ps.length - 1;
			var next:Vector.<Point> = new Vector.<Point>();
			for (var i:int = 0; i < k; i++) next.push(new Point(ps[i].x * (1 - t) + ps[i + 1].x * t, ps[i].y * (1 - t) + ps[i + 1].y * t));
			ps = next;
		}
		return ps[0];
	}
}