/**
 * Copyright tail_y ( http://wonderfl.net/user/tail_y )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jCTo
 */

package{
	import flash.events.Event;
	import flash.display.StageQuality;
	import flash.display.Graphics;
	import flash.utils.getTimer;
	import flash.text.TextField;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;

	/**
	 * @author tail
	 */
	public class QualityChangeTest extends Sprite{
		public function QualityChangeTest(){
			WonderflTemplate.Initialize(this, Initialize, 20, 0xffffff, 10);
		}
		
		private var _count:int = 0;
		
		public function Initialize():void{
			stage.quality = StageQuality.HIGH;
			addEventListener(Event.ENTER_FRAME, frame);
		}
		
		public function frame(event:Event):void{
			_count++;
			if (_count == 10){
				testDo();
			}
		}
		private function testDo():void{
			var testTimes:int = 4000;
			var half:int = testTimes / 2;
			
			var shape:Shape = new Shape();
			var g:Graphics = shape.graphics;
			var displayBmd:BitmapData = new BitmapData(465, 465, true, 0x00000000);
			addChild(new Bitmap(displayBmd));
			var displayTf:TextField = new TextField();
			displayTf.width = 300;
			displayTf.height = 300;
			addChild(displayTf);
			var displayMessage:String = "";
			
			
			var i:int;
			var time:int;
			var time2:int;
			
			
			
			stage.quality = StageQuality.HIGH;
			time = getTimer();
			for (i = 0; i < testTimes; i++) {
				if (i == half){
					stage.quality = StageQuality.LOW;
				}
				g.clear();
				g.lineStyle(1, 0xff8800);
				g.moveTo(150, i*0.1);
				g.lineTo(250, i*0.1 + 10);
				displayBmd.draw(shape);
			}
			time2 = getTimer();
			displayMessage += "１度だけ切り替え " + (time2 - time) + "ms\n";
			
			
			stage.quality = StageQuality.HIGH;
			time = getTimer();
			for (i = 0; i < testTimes; i++) {
				if (i % 2 == 0){
					stage.quality = StageQuality.HIGH;
				}else {
					stage.quality = StageQuality.LOW;
				}
				g.clear();
				g.lineStyle(1, 0xff8800);
				g.moveTo(300, i*0.1);
				g.lineTo(400, i*0.1 + 10);
				displayBmd.draw(shape);
			}
			time2 = getTimer();
			displayMessage += "交互に切り替え " + (time2 - time) + "ms\n";
			
			
			displayTf.text = displayMessage;
		}
	}
}


import flash.display.StageScaleMode;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
/* 初期化テンプレート*/
class WonderflTemplate{
	public static const WIDTH:int = 465;
	public static const HEIGHT:int = 465;
	
	private static var _target:Sprite;
	private static var _handler:Function;
	
	public static function Initialize(target:Sprite, handler:Function, fps:Number, bgColor:uint, captureDelay:int):void{
		_target = target;
		_handler = handler;

		target.stage.frameRate = fps;
		target.stage.scaleMode = StageScaleMode.NO_SCALE;
		
		var bg:Bitmap = new Bitmap(new BitmapData(WIDTH, HEIGHT, false, bgColor));
		target.addChild(bg);

		Wonderfl.capture_delay(captureDelay);
		
		target.addEventListener(Event.ADDED_TO_STAGE, addToStageHandler);
	}
	private static function addToStageHandler(event:Event):void{
		_target.removeEventListener(Event.ADDED_TO_STAGE, addToStageHandler);
		_handler();
	}
}