/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j9Cg
 */

// forked from miyaoka's moyou
package 
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	
	public class Main extends Sprite 
	{
		private var col:uint = 20;
		private var row:uint = 10;
		private var bgColors:Array = [0xFFFFFF, 0x000000];
		private var bgColorIdx:uint = 0;
		
		public function Main():void 
		{
			setShapes();
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseClickHandler);
		}
		private function mouseClickHandler(evt:MouseEvent):void 
		{
			setShapes();
		}	
		private function setShapes():void 
		{
			graphics.clear();
			graphics.beginFill(bgColors[bgColorIdx]);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			bgColorIdx = ++bgColorIdx % bgColors.length;
			
			while(0 < numChildren) removeChildAt(0);
			
			var c:uint;
			var r:uint;
			var rot:uint;

			var size:Number = 25;
			var center:Number = (Math.random() * 2 - 1) * size * 0.5;
			
			for (rot = 0; rot < 4; rot++)
			{
				var xDif:Number = ((rot == 0 || rot == 3) ? 1: -1);
				var yDif:Number =  ((rot == 0 || rot == 1) ? 1: -1);
				for (c = 0; c < col; c++)
				{
					for (r = 0; r < row; r++)
					{
						var sp:Shape = new Shape(this, size, center,center);
						sp.rotation = 90 * rot;
						sp.x = size * c + size * xDif;
						sp.y = size * 2 * (r + c%2*0.5) + size * yDif;
					}
				}
			}
		}
	}	
}


import flash.display.DisplayObjectContainer;
import flash.display.Sprite
import flash.events.MouseEvent;
import flash.geom.Point;

class Shape
extends Sprite
{
	private var size:Number;
	public function Shape(parent_:DisplayObjectContainer, size_:Number = 25, centerX:Number = 0, centerY:Number = 0 ):void 
	{
		parent_.addChild(this);
		stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler, false, 0, true);
		
		size = size_;

        graphics.beginFill(Math.random() * 0xFFFFFF);
		graphics.moveTo(size / 2 - centerX, 0 - centerY);
		graphics.curveTo(size - centerX, 0 - centerY, size/2 - centerX, size/2 - centerY);
		graphics.curveTo(0 - centerX, size - centerY, 0 - centerX, size/2 - centerY);
		graphics.curveTo(0 - centerX, 0 - centerY, size/2 - centerX, 0 - centerY);	
        graphics.endFill();
	}
	private function mouseMoveHandler(evt:MouseEvent):void 
	{
		 scaleX = scaleY = Math.sqrt(size / Point.distance(new Point(), new Point(mouseX, mouseY))) * 2;
	}
}
