/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j93L
 */

package
{
    import flash.display.Sprite;
    
    public class Main extends Sprite
    {
        public function Main()
        {
            addChild(new Board());
        }
    }
}

import com.bit101.components.Label;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Point;

class Board extends Sprite
{
    public static const WIDTH:int = 8;    // 8 * 8マス
    public static const HEIGHT:int = 8;
    public static const SIZE:int = 30;    // 1マスは30 * 30px
    
    private var board:Array;
    private var turn:int;
    private var blackCount:int = 2;
    private var whiteCount:int = 2;
    private var countLabel:Label;

    public function Board()
    {
        countLabel = new Label(this, 270, 50);
        countLabel.scaleX = countLabel.scaleY = 2;

        board = [];
        for (var y:int = 0; y < HEIGHT; y++)
        {
            board[y] = [];
            for (var x:int = 0; x < WIDTH; x++)
            {
                board[y][x] = State.NONE;
            }
        }
        board[3][3] = board[4][4] = State.WHITE;
        board[3][4] = board[4][3] = State.BLACK;
        
        turn = State.BLACK; // 先手は黒
        
        addEventListener(Event.ENTER_FRAME, draw);
        addEventListener(MouseEvent.CLICK, onMouseClick);
    }
        
    // クリックされたとき
    private function onMouseClick(event:MouseEvent):void 
    {
        var tx:int = mouseX / SIZE;
        var ty:int = mouseY / SIZE;
        
        if (!onBoard(tx, ty)) return;
        
        var vec:Vector.<Point> = flipCheck(turn, tx, ty);
        //　反転できるマスが一つでもあるなら、(tx, ty)の位置に石を置くことが出来る
        if (vec.length != 0)
        {
            put(tx, ty, turn, vec); // 引数の後ろにvecを追加
            turnChange();
            updateCount();
        }
    }
    
    // ターンチェンジ
    private function turnChange():void
    {
        if (turn == State.BLACK) turn = State.WHITE;
        else turn = State.BLACK;
    }

    // board[y][x]にcolor石を置き、vecに入っているマスの色を反転する。
    private function put(x:int, y:int, color:int, vec:Vector.<Point>):void
    {
        board[y][x] = color;
        for each (var p:Point in vec)
        {
            if (board[p.y][p.x] == State.BLACK) board[p.y][p.x] = State.WHITE;
            else board[p.y][p.x] = State.BLACK;
        }
    }
    
    // 盤面内のマスをクリックしていたらtrue, していなかったらfalse
    private function onBoard(x:int, y:int):Boolean
    {
        if (x < 0 || WIDTH  <= x) return false;
        if (y < 0 || HEIGHT <= y) return false;
        
        return true;
    }
    
    private function flipCheck(color:int, x:int, y:int):Vector.<Point>
    {
        var vec:Vector.<Point> = new Vector.<Point>();
        if (board[y][x] == State.NONE)
        {
            for (var dy:int = -1; dy <= 1; dy++)
            {
                for (var dx:int = -1; dx <= 1; dx++)
                {
                    vec = vec.concat(flipCheck2(color, x, y, dx, dy));
                }
            }
        }
        
        return vec;
    }
    
    private function flipCheck2(color:int, x:int, y:int, dx:int, dy:int):Vector.<Point>
    {
        var vec:Vector.<Point> = new Vector.<Point>();
        
        while (true)
        {
            x += dx;
            y += dy;
            
            if (!onBoard(x, y) || board[y][x] == State.NONE)
            {
                vec.length = 0;
                break;
            }
            if (board[y][x] == color) break;
            vec.push(new Point(x, y));
        }
        
        return vec;
    }
    
    // 毎フレーム描画
    private function draw(event:Event = null):void
    {
        countLabel.text = "Black " + blackCount + " : White " + whiteCount;
        
        graphics.clear();
        for (var y:int = 0; y < HEIGHT; y++)
        {
            for (var x:int = 0; x < WIDTH; x++)
            {
                var tx:int = x * SIZE;
                var ty:int = y * SIZE;
                
                graphics.lineStyle(1.0);
                graphics.beginFill(0xA0C000);
                graphics.drawRect(tx, ty, SIZE, SIZE);
                graphics.endFill();
                
                if (board[y][x] == State.NONE) continue;
                
                graphics.beginFill(Color.LIST[board[y][x]]);
                graphics.drawCircle(tx + SIZE / 2, ty + SIZE / 2, SIZE / 3);
                graphics.endFill();
            }
        }
    }
    
    // 石の数を数えるメソッド
    private function updateCount():void
    {
        blackCount = whiteCount = 0;
        for (var y:int = 0; y < HEIGHT; y++)
        {
            for (var x:int = 0; x < WIDTH; x++)
            {
                if (board[y][x] == State.BLACK) blackCount++;
                else if (board[y][x] == State.WHITE) whiteCount++;
            }
        }
    }
}

class State
{
    public static const NONE:int = 0;
    public static const BLACK:int = 1;
    public static const WHITE:int = 2;
}

class Color
{
    public static const LIST:Array = [0, 0x0, 0xFFFFFF];
}