/**
 * Copyright goldsource ( http://wonderfl.net/user/goldsource )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j8HZ
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    [SWF(backgroundColor="#000000", frameRate="60")]
    
     /**
     * SomeSpiral
     * No interactivity, just watch
     * @author Nicholas Schreiber
     **/
    public class SomeSpiral extends Sprite
    {
        public static const EMITTERS:uint = 256;
        public static const WIDTH:uint = 465;
        public static const HEIGHT:uint = 465;
        private var __emitters:Vector.<SpiroEmitter> = new Vector.<SpiroEmitter>;
        private var __fx:Bitmap = new Bitmap( new BitmapData(WIDTH, HEIGHT,false, 0x0),PixelSnapping.AUTO,false);
        private var __screen:Bitmap = new Bitmap( new BitmapData(WIDTH, HEIGHT,false, 0x0),PixelSnapping.AUTO,false);
        private var __blurFilter:BlurFilter = new BlurFilter(2,2,1);
        public function SomeSpiral()
        {        
            addChild(__fx);
            addChild(__screen);
            __screen.blendMode = BlendMode.ADD;
            for (var i:uint = 0; i<EMITTERS;i++)__emitters.push(new SpiroEmitter(__screen));
            addEventListener(Event.ENTER_FRAME,__onEnterFrame);
        }
        
        private function __onEnterFrame($e:Event):void{
            var scale:Number = 1.5;
            var matrix:Matrix = new Matrix();
            matrix.scale(scale,scale);
            matrix.tx = (WIDTH-WIDTH*scale)/2;
            matrix.ty = (HEIGHT-HEIGHT*scale)/2;
            __fx.bitmapData.applyFilter(__fx.bitmapData,__fx.bitmapData.rect,new Point(),__blurFilter);
            __screen.bitmapData.applyFilter(__screen.bitmapData,__screen.bitmapData.rect,new Point(),__blurFilter);
            __fx.bitmapData.draw(__screen.bitmapData,matrix);
            for(var i:uint=0;i<__emitters.length;i++)__emitters[i].render();        
        }        
    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.PixelSnapping;
import flash.display.Sprite;
import flash.events.Event;

internal class SpiroEmitter{    
    private var __ticksPerFrame:uint;
    private var __width:uint;
    private var __height:uint; 
    private var __centerX:uint;
    private var __centerY:uint;    
    private var __screen:Bitmap;
    private var __currentIteration:uint;
    private var __angleOffset:Number;
    private var __radiusFactor:uint;
    private var __color:uint;
    private var __anglePerIteration:Number;
    public function SpiroEmitter($screen:Bitmap){
        super();
        __width = $screen.bitmapData.width;
        __height =  $screen.bitmapData.height;
        __centerX = __width/2;
        __centerY = __height/2;
        __screen = $screen;
        __randomize();        
    }
    
    private function __randomize():void{
        __currentIteration=0;    
        __anglePerIteration = 1/(5+Math.random()*5);
        __ticksPerFrame = 1+Math.random()*20
        __radiusFactor = 1+Math.random()*200;
        __angleOffset = Math.random()*360;
        __color = Math.random()*0xFFFFFF;
    }
    
    public function render():void{
        for(var i:uint=0;i<__ticksPerFrame;i++)renderTick();
    }
    
    public function renderTick():void{
        var x1:Number = __centerX+__currentIteration/__radiusFactor*Math.cos((__currentIteration*__anglePerIteration+__angleOffset)*Math.PI/180);
        var y1:Number = __centerY+__currentIteration/__radiusFactor*Math.sin((__currentIteration*__anglePerIteration+__angleOffset)*Math.PI/180);
        if(x1>__width || x1<0 || y1>__height || y1<0){
            __randomize();
            return;
        }        
        __screen.bitmapData.setPixel(x1,y1,__color);
        __currentIteration++;        
    }
}
