/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j8GO
 */

package  
{
    import com.adobe.serialization.json.JSON;
    import com.bit101.components.InputText;
    import com.bit101.components.PushButton;
    import com.bit101.components.VBox;
    import com.bit101.components.Label;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.FocusEvent;
    import flash.events.HTTPStatusEvent;
    import flash.events.IEventDispatcher;
    import flash.events.IOErrorEvent;
    import flash.events.KeyboardEvent;
    import flash.events.ProgressEvent;
    import flash.events.UncaughtErrorEvent;
    import flash.net.SharedObject;
    import flash.net.SharedObjectFlushStatus;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.ui.Keyboard;
    import net.wonderfl.data.APICodeData;
    import net.wonderfl.data.CodeData;
    import net.wonderfl.utils.WonderflAPI;
    
    /**
     * ...
     * @author sandcastles
     */
    public class AccessingWonderflApiByCode extends Sprite 
    {
        static public const CODE_STATE:String = "codeState";
        static public const USER_STATE:String = "userState";
        static private const CODE_CHARACTERS_AMOUNT:int = 4;
        private var VALID_CODES:Array = ['kace','phy5','616f','hwdy','8dk6','AdkO','kXJq','8Z3G','sKBb','5So5','vu5P','Aloh'];
        private var apiParameters:Object={};
        private var wonderflAPI:WonderflAPI;
        private var wonderflDataLoader:URLLoader;
        private var uRLRequest:URLRequest;
        private var loaders:Vector.<SafeLoader>;
        private var scaleToApply:Number;
        private var w:Function;
        private var searchInputText:InputText;
        private var gap:Number;
        private var loadedY:Number;
        private var completeHandler:Function;
        private var ladr:SafeLoader;
        private var loadscount:int;
        private var state:String=CODE_STATE;
        private var sCKeyBoard:SCKeyBoard;
        private var sharedObject:SharedObject;
        private var menu:VBox;
        private var savedCodesList:Array;
        private var isMenuHidden:Boolean;
        static private var console:Console;
        private var initKeyBoardConfiguration:Object;
        
        public function AccessingWonderflApiByCode() 
        {
            console = new Console(this);
            initKeyBoardConfiguration = {
                D:pushTfUp,
                F:toggleMenuVisibility
            }
            Security.allowDomain("*");
            sCKeyBoard = new SCKeyBoard(stage);
            sCKeyBoard.keyAndFunction = ObjectUtils.simpleClone(initKeyBoardConfiguration);
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            apiParameters["open_api_key"] = 'a76b80051993a7c6322bf8b4bbc457b44c3d4f5c';
            wonderflAPI = new WonderflAPI(apiParameters);
            wonderflDataLoader = new URLLoader;
            uRLRequest = new URLRequest;
            loaders = Vector.<SafeLoader>([]);
            stateCodeSet();
            setSharedObject();
        }
        
        private function setSharedObject():void 
        {
            if (state==USER_STATE) 
            {
                return;
            }
            sharedObject = SharedObject.getLocal("application-name");
            menu = new VBox(this, 0, 30);
            var buttonWithClose:ButtonWithClose;
            if (sharedObject.data.savedCodes) 
            {
                savedCodesList = (sharedObject.data.savedCodes as Array).concat();
                for (var i:int = 0; i < savedCodesList.length; i++) 
                {
                    var item:String = savedCodesList[i];
                    cTrace( "item : --------->" + item );
                    addButtonToMenu(item);
                }
            }
            else
            {
                savedCodesList = [];
            }
        }
        
        private function addButtonToMenu(item:String):void 
        {
            var buttonWithClose:ButtonWithClose = new ButtonWithClose(null, 0, 0, item, codeClick);
            menu.addChildAt(buttonWithClose, menu.numChildren);
            buttonWithClose.signal.add(onButtonCloseClick)
        }
        
        private function onButtonCloseClick(codeArg:String):void 
        {
            var s:Array = savedCodesList;
            var item:String;
            for (var i:int = 0; i < s.length; i++) 
            {
                item = s[i];
                
                if (item==codeArg) 
                {
                    savedCodesList.splice(i, 1);
                    saveSharedObject()
                    break;
                }
            }
        }
        
        private function codeClick(e:Event):void 
        {
            //PushButton(e.target).label
            uRLRequest = wonderflAPI.apiCode(PushButton(e.target).label);
            doLoad();
            
        }
        
        private function cTrace(msg:String):void 
        {
            traceIt(msg);
        }
        
        static public function traceIt(msg:String):void 
        {
            console.traceThis(msg)
            
        }
        
        private function stateCodeSet():void 
        {
            new Label(this, 100, 0, "Type wonderfl code and hit ENTER");
            scaleToApply = 1;
            uRLRequest = wonderflAPI.apiCode(VALID_CODES[uint(VALID_CODES.length*Math.random())]);
            w = wonderflDataCompleteByCode;
            completeHandler = codeCompleteHandler;
            searchInputText = new InputText(this, 0, 0, '', onChange);
            searchInputText.addEventListener(FocusEvent.FOCUS_IN, onFocusIn);
            searchInputText.addEventListener(FocusEvent.FOCUS_OUT, onFocusOut);
            gap = 1;
            loadedY = 25;
            doLoad();
        }
        
        private function onFocusOut(e:FocusEvent):void 
        {
            searchInputText.addEventListener(FocusEvent.FOCUS_IN, onFocusIn);
            removeEventListener(KeyboardEvent.KEY_DOWN, doSearch);
            sCKeyBoard.keyAndFunction = ObjectUtils.simpleClone(initKeyBoardConfiguration);
        }
        
        private function onFocusIn(e:FocusEvent):void 
        {
            //stage.removeEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            sCKeyBoard.removeKey("D");
            sCKeyBoard.removeKey("F");
            searchInputText.removeEventListener(FocusEvent.FOCUS_IN, onFocusIn);
            addEventListener(KeyboardEvent.KEY_DOWN, doSearch);
            searchInputText.textField.setSelection(0, searchInputText.text.length - 1);
        }
        
        private function doSearch(e:KeyboardEvent):void 
        {
            var condition:Boolean = true;
            condition = (e.keyCode == Keyboard.ENTER ) ;
            condition = condition && searchInputText.text.length == CODE_CHARACTERS_AMOUNT;
            if (condition ) 
            {
                var toSave:String = searchInputText.text;
                uRLRequest = wonderflAPI.apiCode(searchInputText.text);
                var s:Array = savedCodesList;
                var isCode:Boolean = false;
                for (var i:int = 0; i < s.length; i++) 
                {
                    var item:String = s[i];
                    if (toSave==item) 
                    {
                        isCode = true;
                    }
                }
                if (!isCode) 
                {
                    savedCodesList[savedCodesList.length] = toSave;
                    saveSharedObject();
                    addButtonToMenu(toSave);
                }
                doLoad();
                
            }
        }
        private function saveSharedObject():void 
        {
            sharedObject.data.savedCodes = savedCodesList.concat();
            var flushStatus:String = null;
            try {
                flushStatus = sharedObject.flush(10000);
            } catch (error:Error) {
                cTrace("Error...Could not write SharedObject to disk\n");
            }
            if (flushStatus != null) {
                switch (flushStatus) {
                    case SharedObjectFlushStatus.PENDING:
                        throw new Error("Requesting permission to save object...\n");
                        break;
                    case SharedObjectFlushStatus.FLUSHED:
                        cTrace("Value flushed to disk.\n");
                        cTrace( "sharedObject.data.savedCodes : .............." + sharedObject.data.savedCodes );
                        break;
                }
            }
        }        
        private function toggleMenuVisibility():void 
        {
            swapChildren(menu, getChildAt(numChildren - 1));
            menu.x = isMenuHidden ?10: -menu.width - 10
            /*
            if (!isMenuHidden) 
            {
                isMenuHidden = true;
            }
            else
            {
                menu.x = 10;
                isMenuHidden=false
            }
            */
            isMenuHidden=!isMenuHidden
        }
        
        private function pushTfUp():void 
        {
            swapChildren(console, getChildAt(numChildren - 1));
            swapChildren(searchInputText, getChildAt(numChildren - 1));
        }
        
        private function onChange(e:Event):void 
        {
            
        }
        
        private function codeCompleteHandler(e:Event):void 
        {
            trace( "e : " + e );
        }
        
        private function wonderflDataCompleteByCode(e:Event):void 
        {
            var rawData:Object = JSON.decode(wonderflDataLoader.data);    
            
            var aPICodeData:APICodeData = new APICodeData(rawData);
            var c:CodeData = aPICodeData.code;
            addLoader(c.swf)
        }
        
        private function doLoad():void 
        {
            wonderflDataLoader.addEventListener(Event.COMPLETE, w );//wonderflDataCompleteByCode,wonderflDataCompleteByUser
            wonderflDataLoader.load(uRLRequest);
            
        }
        private function addLoader(url:String):void 
        {
            clearLoader();
            ladr = new SafeLoader();
            loaders[loaders.length] = ladr as SafeLoader;
            loadscount++;
            ladr.x = (loadscount + 1) * gap;
            ladr.y = loadedY;  
            ladr.scaleX = ladr.scaleY = scaleToApply;
            configureListeners(ladr.contentLoaderInfo);
            ladr.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, ladrUncaught);
            ladr.contentLoaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, uncaughtErrorHandler);
            var urlReq:URLRequest = new URLRequest(url);
            ladr.load(urlReq);
            var a:DisplayObject = addChild(ladr);
            a.loaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, uncaughtErrorHandler);
        }
        
        private function uncaughtErrorHandler(e:UncaughtErrorEvent):void 
        {
            
        }
        
        private function ladrUncaught(e:UncaughtErrorEvent):void 
        {
            
        }
        
        private function clearLoader():void 
        {
            if (ladr && state==CODE_STATE)
            {
                ladr.unload();
                removeChild(ladr);
                if (ladr.loaderInfo) 
                {
                    ladr.loaderInfo.uncaughtErrorEvents.removeEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, uncaughtErrorHandler);
                }
                ladr.uncaughtErrorEvents.removeEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, ladrUncaught);
                ladr.contentLoaderInfo.uncaughtErrorEvents.removeEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, uncaughtErrorHandler);
                configureListeners(ladr.contentLoaderInfo, false);
                ladr = null;
            }
        }
        private function configureListeners(dispatcher:IEventDispatcher, isAdding:Boolean = true):void 
        {
            var a:Function = isAdding ? dispatcher.addEventListener : dispatcher.removeEventListener;
            a(Event.COMPLETE, completeHandler);//codeCompleteHandler,userCompleteHandler
            a(HTTPStatusEvent.HTTP_STATUS, httpStatusHandler);
            a(Event.INIT, initHandler);
            a(IOErrorEvent.IO_ERROR, ioErrorHandler);
            a(Event.OPEN, openHandler);
            a(ProgressEvent.PROGRESS, progressHandler);
            a(Event.UNLOAD, unLoadHandler);
        }
        
        private function unLoadHandler(e:Event):void 
        {
            
        }
        
        private function progressHandler(e:ProgressEvent):void 
        {
            
        }
        
        private function openHandler(e:Event):void 
        {
            
        }
        
        private function ioErrorHandler(e:IOErrorEvent):void 
        {
            
        }
        
        private function initHandler(e:Event):void 
        {
            
        }
        
        private function httpStatusHandler(e:HTTPStatusEvent):void 
        {
            
        }
        
    }

}
import com.bit101.components.HBox;
import com.bit101.components.Label;
import com.bit101.components.PushButton;
import com.bit101.components.TextArea;
import com.bit101.components.VBox;
import flash.display.DisplayObjectContainer;
import flash.display.Loader;
import flash.display.Sprite;
import flash.display.Stage;
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.text.TextField;
import flash.ui.Keyboard;
import idv.cjcat.signals.Signal;
class SafeLoader extends Loader
{    
    public function SafeLoader()
    {
        trace('SafeLoader()');
    }
    override public function get stage():Stage 
    {
        return super.stage;
    }
}
class SCKeyBoard
{
    private var _stage:Stage;
    private var object:Object;
    public var keyAndFunction:Object;
    
    public function SCKeyBoard(stageArg:Stage) 
    {
        _stage = stageArg;
        _stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
    }
    
    public function removeKey(key:String):void 
    {
        var k:Object = keyAndFunction;
        for (var name:String in k) 
        {
            if (name==key) 
            {
                trace( "(name==key) : " + (name==key) );
                k[name] = null;
                break;
            }
        }
    }
    
    public function addKeyAndFunction(key:String,callBack:Function):void 
    {
        keyAndFunction[key] = callBack;
    }
    
    private function keyDownHandler(e:KeyboardEvent):void 
    {
        if (!keyAndFunction) 
        {
            throw new Error("keyAndFunction should be defined");
        }
        var callBack:Function;
        if (keyAndFunction[String.fromCharCode(e.keyCode)]) 
        {
            trace( "keyAndFunction[String.fromCharCode(e.keyCode)] : " + keyAndFunction[String.fromCharCode(e.keyCode)] );
            callBack = keyAndFunction[String.fromCharCode(e.keyCode)]
            callBack();
        }
    }
    
    
}
class ButtonWithClose extends HBox
{
    private var pushButton:PushButton;
    private var close:PushButton;
    public var signal:Signal;
    public function ButtonWithClose(parent:DisplayObjectContainer=null,xpos:Number=0,ypos:Number=0,label:String="",defaultHandler:Function=null,largeName:String="") 
    {
        super(parent, xpos, ypos);
        pushButton = new PushButton(null, 0, 0,label,defaultHandler);
        close = new PushButton(null, 0, 0, "x", doClose);
        addChildAt(pushButton, numChildren);
        addChildAt(close, numChildren);
        if (largeName!="") 
        {
            addChildAt(new Label(null,0,0,largeName), numChildren);
        }
        signal = new Signal(String);
        
    }
    
    override public function draw():void 
    {
        super.draw();
        close.setSize(20, 20);
    }
    
    private function doClose(e:Event):void 
    {
        parent.removeChild(this);
        signal.dispatch(pushButton.label);
    }
    
    
}
class Console extends VBox
{
    private var _textField:TextField;
    private var _msprite:Sprite;
    public function Console(msprite:Sprite) 
    {
        super();
        _msprite = msprite;
        _msprite.addChild(this);
        addChildAt(new PushButton(null, 0, 0, "clear", doClear), numChildren);;
        var textArea:TextArea = new TextArea();
        addChildAt(textArea, numChildren);
        _textField = textArea.textField
        x = 465;
        stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDownHandler);
        textArea.setSize(465, 430);
        var sCKeyBoard:SCKeyBoard = new SCKeyBoard(stage);
        sCKeyBoard.keyAndFunction =
        {
            Q:setDebuggerVisibility,
            A:setDebuggerAlpha,
            C:clear
        }
    }
    
    private function clear():void 
    {
        _textField.text = "";
    }
    private function setDebuggerAlpha():void 
    {
        const debuggerAlpha:Number = 0.5;
        alpha = alpha == debuggerAlpha?1:debuggerAlpha;
    }
    
    private function setDebuggerVisibility():void 
    {
        visible = !visible;
    }
    
    private function onKeyDownHandler(e:KeyboardEvent):void 
    {
        switch (e.keyCode) 
        {
            case Keyboard.UP:
                _textField.scrollV -= 10;
            break;
            case Keyboard.DOWN:
                _textField.scrollV += 10;
            break;
            default:
                
            break;
        }
    }
    
    private function doClear(e:Event):void 
    {
        _textField.text = "";
    }
    
    public function get textField():TextField 
    {
        return _textField;
    }
    
    public function set textField(value:TextField):void 
    {
        _textField = value;
    }
    
    public function traceThis(msg:String):void 
    {
        _textField.appendText(msg + "\n");
        _textField.scrollV = textField.maxScrollV;
        
    }
}
class ObjectUtils
{
    static public function simpleClone(input:Object):Object
    {
        var output:Object = { };
        for (var name:String in input) 
        {
            output[name]=input[name]
        }
        return output;
    }
}