/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j840
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.net.*;
    import flash.geom.*;
    import flash.system.*;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            if( stage ) init();
            else addEventListener( Event.ADDED_TO_STAGE, init );
        }
        private function init(e:Event=null):void {
            stage.addEventListener( Event.RESIZE, resize );
            resize();
            
            var loader:Loader= new Loader();
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, loadComplete );
            var req:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/0/09/0975/0975e3fcebd91b0fa8b202ea2997e512772b154e");
            var context:LoaderContext = new LoaderContext( true );
            loader.load( req, context );
        }
        private var _canvas:BitmapData;
        private var _source:BitmapData;
        private var _map:BitmapData;
        private function loadComplete (e:Event) :void {
            _source= new BitmapData(rect.width,rect.height,false,0);
            _canvas = _source.clone();
            _map = _source.clone();
            
            addChild( new Bitmap( _canvas ) );
            
            _source.draw( e.target.loader as Loader );
            
            var mapdisplay:DisplayObject = addChild( new Bitmap(_map) );
            mapdisplay.alpha = 0;
            
            _disp.componentX = 1;
            _disp.componentY = 2;
            _disp.scaleX = _disp.scaleY = 100;
            
            addEventListener( Event.ENTER_FRAME, update );
        }
        
        private var _scroll:Point=new Point;
        private var _scrollAngle:Number= 0;
        private var _distPoint:Point = new Point;
        private var _disp:DisplacementMapFilter = new DisplacementMapFilter();
        private function update(e:Event):void {
             var map:BitmapData = new BitmapData(rect.width,rect.height,false,0);
             _scrollAngle+= 6;
             _scroll.x = Math.cos( _scrollAngle/180 * Math.PI ) * 20;
             _scroll.y = Math.sin( _scrollAngle/180 * Math.PI ) * 20;
            map.perlinNoise( 128, 128, 1, 0, true, true, 3, false, [_scroll] );
            //map.threshold(map,map.rect,new Point, ">=", 0x80, 0xf0, 0xFF, true );
            _map.fillRect( _map.rect, 0x00 );
            _map.draw( map );
            
            _disp.mapBitmap = map;
            
            _canvas.draw( _source );
            _canvas.applyFilter( _canvas, _canvas.rect, _distPoint, _disp );
            
        }
        public var rect:Rectangle = new Rectangle();
        public var center:Point = new Point();
        private function resize(e:Event=null):void{
            rect.width = stage.stageWidth;
            rect.height= stage.stageHeight;
            
            center.x=  rect.width/2>>0;
            center.y = rect.height/2>>0;
        }
    }
}