/**
 * Copyright atsumo ( http://wonderfl.net/user/atsumo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j7pO
 */

// forked from kotobuki's FIO Basic Example: LED
// forked from kotobuki's Gainer Basic Example: LED
// 画面上のボタンを押すとFIOボード上のD13に接続されたLEDが点灯し、
// ボタンを離すとボード上もLEDが消灯します
// 
// Reference
// http://funnel.cc/Main/GettingStarted
// http://funnel.cc/Hardware/FIO

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    import funnel.*;
    import funnel.ui.*;

    public class GainerBasic_LED extends Sprite {
        private var fio:Fio;
        private var led:LED;

        private var squareButton:Sprite;

        public function GainerBasic_LED() {
            var config:Configuration = Fio.FIRMATA;
            fio = new Fio([1], config);

            squareButton = new Sprite();
            squareButton.graphics.beginFill(0x808080);
            squareButton.graphics.drawRect(-25, -25, 50, 50);
            squareButton.graphics.endFill();
            squareButton.x = stage.stageWidth / 2;
            squareButton.y = stage.stageHeight / 2;
            squareButton.buttonMode = true;
            this.addChild(squareButton);

            led = new LED(fio.ioModule(1).digitalPin(1));

            squareButton.addEventListener(MouseEvent.MOUSE_DOWN, mousePressed);
            squareButton.addEventListener(MouseEvent.MOUSE_UP, mouseReleased);
        }

        private function mousePressed(e:MouseEvent):void {
            led.on();
            squareButton.scaleX = 1.2;
            squareButton.scaleY = 1.2;
        }

        private function mouseReleased(e:MouseEvent):void {
            led.off();
            squareButton.scaleX = 1.0;
            squareButton.scaleY = 1.0;
        }
    }
}
