/**
 * Copyright k__ ( http://wonderfl.net/user/k__ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j7D1
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.utils.*;
	import flash.filters.*;
	
	public class Main extends Sprite {
		private var canvas:BitmapData;
		private var canvasRect:Rectangle;
		private var brush:Bitmap;
		private var cx:Number,cy:Number;
		private var verts:Vector.<Number>;
		private var pVerts:Vector.<Number>;
		private var uvts:Vector.<Number>;
		private var pmtx:Matrix3D;
		private var pers:PerspectiveProjection;
		private var xr:Number = 0, yr:Number = 0;
		private var particles:Vector.<Particle>;
		private var particleGraphics:Vector.<BitmapData>;
		private var particleRects:Vector.<Rectangle>;
		private var numParticles:uint = 40;
		private var pImg:Vector.<BitmapData>;
		private var pImgRect:Vector.<Rectangle>;
		private var blur:BlurFilter;
		private var oPt:Point;
		
		public function Main() {
			initGraphics();
			blur = new BlurFilter(2,2);
			oPt = new Point(0,0)
			cx = stage.stageWidth / 2;
			cy = stage.stageWidth / 2;
			pVerts = new Vector.<Number>();
			pmtx = new Matrix3D();
			pers = new PerspectiveProjection();
			uvts = new Vector.<Number>();
			particles = new Vector.<Particle>;
			
			addChild(new Bitmap(canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000)));
			canvasRect = canvas.rect;
			for (var i:uint = 0; i < numParticles; i ++) {
				particles.push(new Particle());
				initParticle(particles[i]);
			}
			addEventListener(Event.ENTER_FRAME, h_enterframe);
		}
		
		private function initGraphics():void {
			var shape:Shape = new Shape();
			pImg = new Vector.<BitmapData>;
			pImgRect = new Vector.<Rectangle>;
			for (var i:uint = 0; i < 30; i ++) {
				shape.graphics.clear();
				shape.graphics.beginFill(0x003366);
				var radius:Number = i / 6 + 1;
				shape.graphics.drawCircle(radius, radius, radius);
				shape.graphics.endFill();
				pImg.push(new BitmapData(radius * 2,radius * 2,true, 0x00ffffff));
				pImg[i].draw(shape);
				pImgRect.push(pImg[i].rect);  
			}
		}
		
		private function initParticle(p:Particle):void {
			p.x = p.y = p.z = 0;
			var r:Number = Math.random() * Math.PI *2 ;
			var d:Number = Math.random() * 0.5;
			p.vx = Math.cos(r) * d;
			p.vz = Math.sin(r) * d;
			p.vy = 0;
			p.life = Math.random() * 200 + 300;
		}
		
		private function h_enterframe(evt:Event):void {
			yr = (cx - mouseX) / stage.width * 180;
			xr = 50;
			
			canvas.fillRect(canvasRect, 0x000000);
			for (var i:uint = 0; i < 10; i ++) {
				render();
			}
		}
		
		private function render():void {
			var i:uint;
			pers.fieldOfView = 100;
			pmtx.identity();
			pmtx.appendRotation(yr, Vector3D.Y_AXIS);
			pmtx.appendRotation(xr, Vector3D.X_AXIS);
			pmtx.appendTranslation(0, 0, pers.focalLength);
			pmtx.append(pers.toMatrix3D());
			bugfix(pmtx);
			verts = new Vector.<Number>;
			pVerts = new Vector.<Number>;
			for (i = 0; i < numParticles; i ++) {
				particles[i].x += particles[i].vx;
				particles[i].y += particles[i].vy;
				particles[i].z += particles[i].vz;
				particles[i].vy += 0.02;
				
				if (particles[i].y > 0) {
					particles[i].vy = Math.random() * -2;
				}
				
				particles[i].life --;
				if (particles[i].life < 0) {
					initParticle(particles[i]);
				}
					
				verts.push(particles[i].x);
				verts.push(particles[i].y);
				verts.push(particles[i].z);
			}
			
			
			Utils3D.projectVectors(pmtx, verts, pVerts, uvts);
			
			var fl:Number = pers.focalLength;
			for (i = 0; i < pVerts.length / 2; i ++) {
				var lev:uint = uvts[i * 3 + 2] * fl * 10;
				lev = (lev >= 29) ? 29 : lev;
				
				
				lev = (lev > 255) ? 255 : lev;
				var mtx:Matrix = new Matrix();
				mtx.translate(cx + pVerts[i * 2], cy + pVerts[i * 2 + 1]);
				canvas.draw(pImg[lev], mtx,null, BlendMode.ADD);
			}
			canvas.applyFilter(canvas,canvasRect,oPt, blur);
		}
		
		
		private function bugfix(matrix:Matrix3D):void {
			var m1:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0 ]));
			var m2:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 1,  0, 0, 0, 0 ]));
			m1.append(m2);
			if (m1.rawData[15] == 20) {
				var rawData:Vector.<Number> = matrix.rawData;
				rawData[15] /= 20;
				matrix.rawData = rawData;
			}
		}
		
	}
	
}

class Particle {
	public var x:Number = 0,y:Number = 0,z:Number = 0;
	public var vx:Number = 0,vy:Number = 0,vz:Number = 0;
	public var life:Number = 100;
}