/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j77J
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Point;
 
	public class Main extends Sprite
	{	
		private var bd:BitmapData;
		private var prev:Point = new Point();
		private var preview:Sprite;
 
		public function Main()
		{	
			bd = new BitmapData(stage.stageWidth, stage.stageHeight, false);
			addChild(new Bitmap(bd));
 
			preview = new Sprite();
			addChild(preview);
 
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
 
		private function onMouseDown(event:MouseEvent):void
		{	
			prev.x = mouseX;
			prev.y = mouseY;
 
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
 
		private function onMouseMove(event:MouseEvent):void
		{
			// クリックした地点から現在位置までの二点間距離
			var distance:Number = Math.sqrt(Math.pow(mouseX - prev.x, 2) + Math.pow(mouseY - prev.y, 2));
			preview.graphics.clear();
			preview.graphics.lineStyle(1.0, 0x9F9F9F);
			preview.graphics.drawCircle(prev.x, prev.y, distance);
		}
		 
		private function onMouseUp(event:MouseEvent):void
		{
			var distance:Number = Math.sqrt(Math.pow(mouseX - prev.x, 2) + Math.pow(mouseY - prev.y, 2));
			preview.graphics.clear();
			preview.graphics.lineStyle(8.0, int.MAX_VALUE * Math.random());
			preview.graphics.drawCircle(prev.x, prev.y, distance);
		 
			bd.draw(preview);
		 
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	}
}
