/**
 * Copyright Makoto_Tanaka ( http://wonderfl.net/user/Makoto_Tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j6ji
 */

// forked from Makoto_Tanaka's File Loader
/*
 * ビット}ップデータを直接操作して描画
 */
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    
    import flash.system.Security;
    
    [SWF(width = "465", height = "465", frameRate = "30")]
    public class FlashTest extends Sprite {
        
        private static const WIDTH:int = 465;
        private static const HEIGHT:int = 465;
        
        private var _canvas:BitmapData;
        
        private var _particles:Vector.<Particle> = new Vector.<Particle>();
        
        // コンストラクタ
        public function FlashTest() {
            // write as3 code here..
            initGraphics();
            initSecurity();
            loadImage("http://assets.wonderfl.net/images/related_images/7/7e/7eb1/7eb105ed0d807e337921b22cf04a3ff19b0c4423m");
            
        }
        
        // セキュリティ設定
        private function initSecurity():void {
            Security.allowDomain("assets.wonderfl.net");
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
        }
        
        // 画像のロード
        private function loadImage(url_:String):void　{
            var loader:Loader=new Loader();
            loader.load(new URLRequest(url_));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onComplete);
        }
        
        // グラフィックの初期化
        private function initGraphics():void {
            _canvas = new BitmapData(WIDTH, HEIGHT, false, 0x000000);
            addChild(new Bitmap(_canvas));
        }

        
        // ロードが終了後のイベント
        private function onComplete(event:Event):void　{
            event.target.removeEventListener(Event.COMPLETE, onComplete);
            
            var content:Bitmap = event.target.content;
            var bmd:BitmapData=new BitmapData(content.width, content.height);
            bmd.draw(content);
            
            // 座標、色の保存
            for (var h:int=0; h<bmd.height; h++) {
                for (var w:int=0; w<bmd.width; w++) {
                    var p:Particle = new Particle(w,h,bmd.getPixel(w,h));
                    _particles.push(p);
                }
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        // 描画の更新
        private function onEnterFrame(e:Event):void {
            _canvas.lock();
            _canvas.fillRect(_canvas.rect, 0);
            for (var i:int=0; i<_particles.length; i++) {
                var p:Particle = _particles[i];
                _canvas.setPixel(p.x, p.y, p.color);                
            }
            _canvas.unlock();
        }

    }
}

class Particle {
    
    public var x:Number;
    public var y:Number;
    public var color:uint;
    
    // コンストラクタ
    public function Particle(x_:Number,y_:Number,color_:Number) {
        x = x_;
        y = y_;
        color = color_;
    }

}
