/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j6BM
 */

package 
{
    import com.adobe.serialization.json.JSON;
    import com.bit101.components.PushButton;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    
    /**
     * Google AJAX Feed API + TWITTER FEED
     * @author gaina
     */
    public class Main extends Sprite 
    {
        private var _text:TextField;
        private var _input:TextField;
        private var _btn:PushButton;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            _input = new TextField();
            _input.type = TextFieldType.INPUT;
            _input.border = true;
            _input.borderColor = 0x999999;
            _input.height = 20;
            addChild(_input);
            
            _btn = new PushButton(stage, 105, 0, "send", PushEventHandler);
            
            _text = new TextField();
            _text.width = _text.height = 465;
            _text.wordWrap = true;
            _text.y = 20;
            addChild(_text);
        }
        
        private function PushEventHandler(e:Event):void
        {
            _text.text = "";
            _btn.enabled = false;
            
            if (_input.text == "") _input.text = "gaina";
            
            var _loader:URLLoader = new URLLoader();
            _loader.addEventListener(Event.COMPLETE, onComp);
            
            //Google AJAX Feed API を使用すると、4POSTしかとれない。
            //何か方法があるんかなぁ。
            
            _loader.load(new URLRequest(
                'http://ajax.googleapis.com/ajax/services/feed/load?' + 
                'q=' +
                encodeURIComponent("http://twitter.com/statuses/user_timeline/"+ _input.text + ".rss") +
                '&key=ABQIAAAAek8YSoh7lXIM2HK0MXyC0BSnhvsz13Tv4UkZBHR3eJwOymtuUxTCAeObfFHTadcls418VEWpYrh_RA' +
                '&v=1.0'
            ));
        }
        
        private function onComp(e:Event):void 
        {
            _btn.enabled = true;
            
            var _json:String = URLLoader(e.currentTarget).data;
            
            trace(_json);
            
            var _parse:Object = JSON.decode(_json);
            var i:int = 1;
            for each(var _obj:Object in _parse["responseData"]["feed"]["entries"]) 
            {
                var _content:String = _obj["title"];
                
                _text.appendText("POST:" + i + "\n");
                _text.appendText(_content.substr(_content.indexOf(" ") + 1) + "\n");
                _text.appendText(_obj["link"] + "\n");
                _text.appendText(_obj["publishedDate"] + "\n\n");
                i++;
            }
        }
        
    }
    
}


