/**
 * Copyright naoyago ( http://wonderfl.net/user/naoyago )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j5vn
 */

package {
    import flash.display.AVM1Movie;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    public class FlashTest extends Sprite {
        private const TEXT_INIT_X:int = stage.stageWidth / 2;
        private const TEXT_INIT_Y:int = stage.stageHeight / 2;
        private const TEXT_START_Y:int = 10;
        
        private var text:TextField = new TextField();
        private var text_alpha:Number = 0;
        
        public function FlashTest() {
            // text format
            var text_format:TextFormat = new TextFormat();
            text_format.font = "_ゴシック";
            text_format.align = TextFormatAlign.RIGHT;

            // text
            this.text.defaultTextFormat = text_format;
            this.text.text = String('Hello World');
            this.text.textColor = 0xAAAAAA;
            this.text.width = 100;
            this.text.x = TEXT_INIT_X - this.text.width / 2;
            this.text.y = TEXT_INIT_Y - TEXT_START_Y;
            this.text.alpha = 0;
            stage.addChild(this.text);
            
            // start opening
            stage.addEventListener(Event.ENTER_FRAME, this.startOpening);
        }
        
        // =================================
        // opening
        // =================================
        private var opening_cnt:int = 0;
        
        private function startOpening(e:Event):void {
            this.opening();
        }
        
        private function opening():void {
            this.opening_cnt++;
            
            // wait time
            if (this.opening_cnt < 20){
                return;
            }

            this.text_alpha += 0.1;
            this.text.alpha = this.text_alpha;
            this.text.y += (TEXT_INIT_Y - this.text.y) * 0.3;
            
            if (this.opening_cnt >= 40) {
                // start main
                stage.addEventListener(Event.ENTER_FRAME, this.startMain);
            }
        }
        
        // =================================
        // main
        // =================================
        private function startMain(e:Event):void {
            stage.removeEventListener(Event.ENTER_FRAME, startOpening);
            this.main();
        }
        
        private function main():void {
            // main process
            
            // test
            this.text.textColor = 0xAA0000;
        }
    }
}