/**
 * Copyright Kitosan1986 ( http://wonderfl.net/user/Kitosan1986 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j4rf
 */

　//操作説明：
//画面上の任意の場所をクリック＆ドラッグ。
//するとドラッグ量に応じた大きさの玉が作成される
//いくつかボールを作成したらENTERをクリック！
//作成したボールがメロディを奏でます。
//キーボードの0数字で音色を変えられます

package {
    import flash.display.Sprite;
    import flash.events.*;
     //SiONのインポート
	import org.si.sion.*;
	import org.si.sion.events.*;
	import org.si.sion.effector.*;
	import org.si.sion.utils.SiONPresetVoice;
    
    
    [SWF(backgroundColor="#FFFFFF",width='600',height='600', frameRate=60)]
    
    public class DrawCircle extends Sprite {
    	
    		private var myStage:Sprite = new Sprite();
    		private var VoiceName:String ="valsound.piano4";
 		private var bounce:Number = -1.0;
    		// driver
		private var driver:SiONDriver = new SiONDriver();
		// preset voice
		private var presetVoice:SiONPresetVoice = new SiONPresetVoice(); 
    		//MML
        public var rythmLoop:SiONData;    		
    		private var Balls:Array = new Array();
    		private var Num:uint = 0;
    		private var ball:Ball;
    		private var MouseSw:Boolean = false;//
    		private var OverSw:Boolean = false;//
		//押下時マウスの座標
		private var pre_mx:Number;
		private var pre_my:Number;		
		//マウスを放したときの座標
		private var mx:Number;
		private var my:Number;

		//コンストラクタ
        public function DrawCircle(){        		
        		Back();
        		Stage();
        		driver.play();
        		myStage.addEventListener(MouseEvent.MOUSE_DOWN, MouseDown);
        		stage.addEventListener(KeyboardEvent.KEY_DOWN,KeyDown);
        		
        } 
        private function Stage():void{
        		myStage.graphics.beginFill(0,0);
			myStage.graphics.drawRect(0,0,600,600);
			myStage.graphics.endFill();
			myStage.width = 600;
			myStage.height = 600;
			addChild(myStage);

        	}  
        private function Back():void{
			for(var i:uint;i<8;i++){
				var back:Sprite = new Sprite();
				back.graphics.beginFill(0,0.05);
				back.graphics.drawRect(0,80*i,600,40);
				back.graphics.endFill();
				addChild(back);
			}
        	}
        	
        	private function  KeyDown(e:KeyboardEvent):void{
			if(e.keyCode ==13 ){onPlayBt();}
		
			else if(e.keyCode == 49 ){VoiceName = "valsound.piano3";}
			else if(e.keyCode == 50 ){VoiceName = "valsound.bell2";}
			else if(e.keyCode == 51 ){VoiceName = "valsound.piano19";}
			else if(e.keyCode == 52 ){VoiceName = "valsound.piano6";}
			else if(e.keyCode == 53 ){VoiceName = "valsound.bell5";}
			else if(e.keyCode == 54 ){VoiceName = "valsound.guitar3";}
			else if(e.keyCode == 55 ){VoiceName = "valsound.lead35";}
			else if(e.keyCode == 56 ){VoiceName = "valsound.brass9";}
			else if(e.keyCode == 57 ){VoiceName = "valsound.piano4";}
			else if(e.keyCode == 48 ){VoiceName = "valsound.strpad22";}
		}
		      
        private function MouseDown(event:MouseEvent):void{
        		if(OverSw == false){
        			MouseSw = true;
	        		var cx:Number = myStage.stage.mouseX;
	        		var cy:Number = myStage.stage.mouseY;
	        		pre_mx = cx;
	        		pre_my = cy;
	        		trace(cx);
	        		trace(cy);
	        		MakeBall(cx,cy);
	        		myStage.addEventListener(MouseEvent.MOUSE_MOVE, MouseMove);
        		}    		
        	}
        		
        	private function MouseMove(event:MouseEvent):void{
	        		var dx:Number = ball.x - stage.mouseX;
				var dy:Number = ball.y - stage.mouseY;
	        		var radius:Number = Math.sqrt(dx*dx + dy*dy);
	        		if(radius<10){
	        			ball.width = 20;
					ball.height = 20;
	        			}
	        		else if(radius<30){
					ball.width = 60;
					ball.height = 60;
	        		}
	        		else if(radius<50){
					ball.width = 100;
					ball.height = 100;
	        		}
	        		else if(radius<100){
					ball.width = 200;
					ball.height = 200;
	        		}
        			myStage.addEventListener(MouseEvent.MOUSE_UP, MouseUp);       		
        	}
        	
        	private function MouseUp(event:MouseEvent):void{
        		MouseSw = false;
        		myStage.removeEventListener(MouseEvent.MOUSE_MOVE, MouseMove);
        		if(ball.width==20){ball.NL = 1;ball.noteL="16";}//*noteOnでは16分音符が何個分かで音の長さを制御する.この値はカウンタにも使う
        		else if(ball.width==60){ball.NL =2;ball.noteL="8";}//16*4
        		else if(ball.width==100){ball.NL = 4;ball.noteL="4";}//1/16*8
        		else if(ball.width==200){ball.NL = 16;ball.noteL="1";}//1/16*16        		        		        		        		
        		Sichou();       		


        	}
        private function MakeBall(cx:Number,cy:Number):void{
        		ball = new Ball(20,Math.random()*0xffffff,0.5);
        		myStage.addChild(ball);
        		ball.x = cx;
        		ball.y = cy;
        		Num += 1;
        		ball.buttonMode = true;
        		ball.addEventListener(MouseEvent.MOUSE_OVER,MouseOverd);
        		ball.addEventListener(MouseEvent.MOUSE_OUT,MouseOut);
        		ball.addEventListener(MouseEvent.CLICK,DClicked);
        		Balls.push(ball);
        		
        }
        private function DClicked(event:MouseEvent):void{
        		var target:Ball = event.currentTarget as Ball;
        		ball = event.currentTarget as Ball;
			myStage.removeChild(target);
        }
        
        private function MouseOverd(event:MouseEvent):void{
        		OverSw = true;
        }
        
        private function MouseOut(event:MouseEvent):void{
        		OverSw = false;
        }
        private function Sichou():void{
        		var by:Number = ball.y//現在（最新）のボールのy座標を利用する
        		
        		if(by<40){driver.noteOn(84,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o6c"}//o6C
        		else if(by<80){driver.noteOn(83,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o5b";ball.noteB = "o3b";}//o5B
        		else if(by<120){driver.noteOn(81,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o5a";ball.noteB = "o3a";}//o5A
        		else if(by<160){driver.noteOn(79,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o5g";ball.noteB = "o3g";}//o5G
        		else if(by<200){driver.noteOn(77,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o5f";ball.noteB = "o3f";}//o5F
        		else if(by<240){driver.noteOn(76,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o5e";ball.noteB = "o3e";}//o5E
        		else if(by<280){driver.noteOn(74,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o5d";ball.noteB = "o3d";}//o5D
        		else if(by<320){driver.noteOn(72,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o5c";ball.noteB = "o3c";}//o5C
        		else if(by<360){driver.noteOn(71,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o4b";ball.noteB = "o2b";}//o4B
        		else if(by<400){driver.noteOn(69,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o4a";ball.noteB = "o2a";}//o4A
        		else if(by<440){driver.noteOn(67,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o4g";ball.noteB = "o2g";}//o4G
        		else if(by<480){driver.noteOn(65,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o4f";ball.noteB = "o2f";}//o4F
        		else if(by<520){driver.noteOn(64,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o4e";ball.noteB = "o2e";}//o4E
        		else if(by<560){driver.noteOn(62,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o4d";ball.noteB = "o2d";}//o4D
        		else if(by<600){driver.noteOn(60,presetVoice[VoiceName],ball.NL,0,0,0,0,0,0,true); ball.note = "o4c";ball.noteB = "o2c";}//o4C
       	}        	
		private function onPlayBt():void {
			Num=myStage.numChildren;
			for (var i:uint=0; i<Num; i++) {
				Balls[i]=myStage.getChildAt(i);
			}
			if (Num>0) {
				CompileMML();
			}	
		}		        	

		private function CompileMML():void {
			var target:Ball;
			var count:uint=0;
			var mml:String="#EFFECT1{lf3000delay300,32,1};t120;";
			//メロディ部分の作成
			mml+="%6@0o3l8";
			for (var i:uint=0; i<Num; i++) {
				target=Balls[i];
				mml+=target.noteL;
				mml+=target.note;
			}
			mml+=";";
			//ベース部分の作成
			mml+="%6@1l8";
			target=Balls[0];
			for (var j:uint=0; j<Num; j++) {
				target=Balls[j];
				count+=target.NL;
					if (count==0) {
						for (i=0; i<8; i++) {
							mml+=target.noteB;
						}
					} else if (count > 16) {//このへんの数あやしい要点検
						count=0;
						for (i=0; i<8; i++) {
						mml+=target.noteB;
						}
					}
			}		
			mml+=";";
			/*--------------------------------------ベース終了*/
			
			//ドラムパターン作成(bassDrum)
			count=0;
			mml+="%6@2l8o3";
			for (j=0; j<Num; j++) {
				target=Balls[j];
				count+=target.NL;
				if (count>16) {//このへんの数あやしい要点検
					count=0;
					mml+="ccrccrrr";
				}
			}
			mml+=";";
			
			//ドラムパターン作成(SnareDrum)
			count=0;
			mml+="%6@3l4o3";
			for (j=0; j<Num; j++) {
				target=Balls[j];
				count+=target.NL;
				if (count>16) {//このへんの数あやしい要点検
					count=0;
					mml+="rcrc";
				}
			}
			mml+=";";
			
			//ドラムパターン作成(Hihat)
			count=0;
			mml+="%6@4v4l8o3";
			for (j=0; j<Num; j++) {
				target=Balls[j];
				count+=target.NL;
				if (count>16) {//このへんの数あやしい要点検
					count=0;
					mml+="ccrcccrc";
				}
			}
			mml+=";";
			
			rythmLoop=driver.compile(mml);
			rythmLoop.setVoice(0, presetVoice[VoiceName]);
			rythmLoop.setVoice(1, presetVoice["valsound.bass2"]);
			rythmLoop.setVoice(2, presetVoice["valsound.percus1"]);
			rythmLoop.setVoice(3, presetVoice["valsound.percus30"]);
			rythmLoop.setVoice(4, presetVoice["valsound.percus16"]);
			
			driver.play(rythmLoop);			
		}	
	}   		
}

/*-------------------------------------
			パッケージ外クラス定義
 ---------------------------------------*/

import flash.display.*;
import flash.events.*;
class Ball extends Sprite
{
	private var velocity:Number = 1;//ここに速度を入れる
	public var sw:Boolean = false;
	public var vx:Number =(Math.random() * 10 - 5) * velocity;
	public var vy:Number =(Math.random() * 10 - 5) * velocity;
	public var NL:uint = 1;//カウンタ用の長さ、およびnoteOn時の長さ
	public var note:String;//MMLで使うノート文字
	public var noteB:String; 
	public var noteL:String = "16";//MMLで使う音の長さ。デフォルト値の16は16分音符
	
    //x
    function Ball(rd:Number,cl:Number,al:Number){
		this.width = 20;
    		this.height = 20;    				
        this.graphics.beginFill(cl,al);
        this.graphics.drawCircle(0, 0, 20);
        this.graphics.endFill();

        
    }
}