/**
 * Copyright szbzs2004 ( http://wonderfl.net/user/szbzs2004 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j4X3
 */

package {

    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    [SWF (frameRate="6", backgroundColor="#000000")]
    
    public class UpdateAfterEventDemo extends Sprite {

        private var updateAfterEventEnabled:Boolean = true;
        private var tf:TextField;
        
        public function UpdateAfterEventDemo() {
            tf = new TextField();
            var tfrmt:TextFormat = tf.getTextFormat();
            tfrmt.align = TextFormatAlign.CENTER;
            tfrmt.size = 32;
            tf.defaultTextFormat = tfrmt;
            tf.autoSize = TextFieldAutoSize.CENTER;
            tf.selectable = false;
            toggleUpdateAfterEvent(null);
            addChild(tf);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, moveText);
            stage.addEventListener(MouseEvent.CLICK, toggleUpdateAfterEvent);
        }

        private function moveText(e:MouseEvent):void {
            tf.x = mouseX - tf.width / 2;
            tf.y = mouseY - tf.height / 2;
            if (updateAfterEventEnabled) {
                e.updateAfterEvent();
            }
        }

        private function toggleUpdateAfterEvent(e:MouseEvent):void {
            updateAfterEventEnabled = !updateAfterEventEnabled;
            tf.text = "updateAfterEvent() - " + updateAfterEventEnabled + "\nClick to change!";
            tf.textColor = updateAfterEventEnabled ? 0x00ff00 : 0xff0000;
        }
    }
}