/**
 * Copyright tananuka13 ( http://wonderfl.net/user/tananuka13 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j4QU
 */

// forked from ProjectNya's ズキュウウウン光るパンダ
////////////////////////////////////////////////////////////////////////////////
// ズキュウウウン光るパンダ
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.system.LoaderContext;
    import flash.display.Shape;
    import flash.geom.Matrix;
    import flash.display.GradientType;
    import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import flash.display.BlendMode;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var angle:Number = 0;
        private static var radius:uint = 120;
        private static var speed:uint = 3;
        private static var radian:Number = Math.PI/180;
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var sunshinePath:String = "9/9b/9bbe/9bbec77d53bddc5e7a5f2c00abbade6bd641c549";
        private static var lightPath:String = "4/40/400b/400b814a16b90c750e41bcd00890213280cd1be7";
        private var loader:Loader;
        private static var pandaPath:String = "http://www.project-nya.jp/images/flash/panda2d.swf";
        private var Panda:Class;
        private var panda:MovieClip;
        private var trianglelines:TriangleLines;
        private var light:Sprite;

        public function Main() {
            //Wonderfl.disable_capture();
            //Wonderfl.capture_delay(4);
            init();
        }

        private function init():void {
            draw();
            //
            Security.allowDomain("www.project-nya.jp");
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(pandaPath), new LoaderContext(true));
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            trianglelines = new TriangleLines(rect, 0x000000);
        }
        private function complete(evt:Event):void {
            loader.removeEventListener(Event.COMPLETE, complete);
            var content:MovieClip = MovieClip(evt.target.content);
            //Pandaクラス
            Panda = MovieClip(content.panda).constructor;
            setup();
            loader = null;
        }
        private function setup():void {
            addChild(light);
            //Pandaインスタンス
            panda = new Panda();
            addChild(panda);
            panda.x = 232;
            panda.y = 400;
            panda.scale = 5;
            panda.shade.visible = false;
            panda.handL.stop();
            panda.handR.stop();
            panda.handL.gotoAndPlay(19);
            panda.handR.gotoAndPlay(1);
            addChild(trianglelines);
            trianglelines.start();
        }
        /////////////////////////////////////////////
        //背景
        /////////////////////////////////////////////
        private function draw():void {
            drawSky();
            drawGround();
            drawSun();
            drawLight();
        }
        private function drawSky():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 350, 0.5*Math.PI, 0, 0);
            graphics.beginGradientFill(GradientType.LINEAR, [0x3F68AB, 0x77B2EE], [1, 1], [0, 255], matrix);
            graphics.drawRect(0, 0, 465, 350);
            graphics.endFill();
        }
        private function drawGround():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 115, 0.5*Math.PI, 0, 350);
            graphics.beginGradientFill(GradientType.LINEAR, [0x99CC33, 0x7EB133], [1, 1], [0, 255], matrix);
            graphics.drawRect(0, 350, 465, 115);
            graphics.endFill();
        }
        private function drawSun():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(200, 200, 0, -90, -90);
            graphics.beginGradientFill(GradientType.RADIAL, [0xFFFFFF, 0xFFFFFF, 0xFFFFFF], [1, 0.3, 0], [25, 102, 231], matrix);
            graphics.drawCircle(10, 10, 100);
            graphics.endFill();
            var shine:Loader = new Loader();
            addChild(shine);
            shine.alpha = 0.5;
            shine.load(new URLRequest(basePath + sunshinePath), new LoaderContext(true));
        }
        private function drawLight():void {
            light = new Sprite();
            //addChild(light);
            light.x = 232;
            light.y = 232;
            light.blendMode = BlendMode.ADD;
            var _loader:Loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.INIT, initialize, false, 0, true);
            _loader.load(new URLRequest(basePath + lightPath), new LoaderContext(true));
        }
        private function initialize(evt:Event):void {
            var content:Bitmap = Bitmap(evt.target.content);
            content.x = -128*3;
            content.y = -128*3;
            content.scaleX = content.scaleY = 3;
            content.smoothing = true;
            light.addChild(content);
            addEventListener(Event.ENTER_FRAME, rotate, false, 0, true);
        }
        private function rotate(evt:Event):void {
            light.rotation += 10;
        }

    }

}


//////////////////////////////////////////////////
// TriangleLinesクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.display.Graphics;
import flash.geom.Matrix;

class TriangleLines extends Sprite {
    private var rect:Rectangle;
    private var canvas:BitmapData;
    private static var radian:Number = Math.PI/180;
    private var color:uint;

    public function TriangleLines(r:Rectangle, c:uint) {
        rect = r;
        color = c;
        init();
    }

    private function init():void {
        canvas = new BitmapData(rect.width, rect.height, true, 0x00000000);
        addChild(new Bitmap(canvas));
    }
    public function start():void {
        drawLines();
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function update(evt:Event):void {
        canvas.lock();
        canvas.fillRect(rect, 0x00000000);
        drawLines();
        canvas.unlock();
    }
    private function drawLines():void {
        var line:Sprite = new Sprite();
        drawTriangle(line.graphics);
        var a:uint = 2;
        var rw:uint = rect.width;
        var rh:uint = rect.height;
        var length:uint = rw/2*Math.sqrt(2);
        for (var n:uint = 0; n < 360; n += Math.round(Math.random()*a)) {
            var dx:Number = Math.sin(n*radian)*length + rw/2;
            var dy:Number = Math.cos(n*radian)*length + rh/2;
            var matrix:Matrix = new Matrix();
            matrix.scale(5, Math.random()*length + length/2);
            matrix.rotate(-n*radian);
            matrix.translate(dx, dy);
            canvas.draw(line, matrix, null, null, null, false);
        }
        line = null;
    }
    private function drawTriangle(g:Graphics):void {
        g.beginFill(color);
        g.moveTo(-0.5, 0);
        g.lineTo(0.5, 0);
        g.lineTo(0, -0.5);
        g.lineTo(-0.5, 0);
        g.endFill();
    }

}
