/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j3A3
 */

package
{
    import caurina.transitions.properties.DisplayShortcuts;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.utils.*;
    import org.papervision3d.core.math.Plane3D;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.shadematerials.GouraudMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.materials.MovieMaterial;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.util.ViewportLayerSortMode;
    public class test2 extends BasicView 
    {
        static private const CAMERA_POSITION : uint = 4500;
        static private const CUBE_SIZE : uint = 600;
        static private const CUBE_SEGMENT : uint = 1;
        static private const CUBE_RANGE_H : uint = 500;
        static private const PLANE_SIZE : uint = 5000;
        static private const LIGHT_POSITION : uint = 2000;
        private var light : PointLight3D;
        private var floor : Plane;
        private var cube : Cube;
        public function test2(): void 
        {
            super(0, 0, true, false);
            viewport.containerSprite.sortMode = ViewportLayerSortMode.INDEX_SORT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            init();
        }
        private function init(): void 
        {
            camera.focus = 500;
            camera.zoom = 2;
            light = new PointLight3D();
            var sprite : Sprite = new Sprite();
            sprite.graphics.beginFill(0xEEEEEE, 1);
            sprite.graphics.drawRect(0, 0, 128, 128);
            sprite.graphics.endFill();
            var mm : MovieMaterial = new MovieMaterial(sprite, false, true, true);
            floor = new Plane(mm, PLANE_SIZE, PLANE_SIZE, 1, 1);
            floor.pitch(90);
            floor.y = -CUBE_RANGE_H * 2;
            scene.addChild(floor);
            viewport.getChildLayer(floor).layerIndex = -100;
            var cm : FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF, 0x666666);
            cube = new Cube(new MaterialsList({all : cm}), CUBE_SIZE, CUBE_SIZE, CUBE_SIZE, CUBE_SEGMENT, CUBE_SEGMENT, CUBE_SEGMENT);
            scene.addChild(cube);
            viewport.getChildLayer(cube).layerIndex = 10;
            addEventListener(Event.ENTER_FRAME, enterframeHandler);
            startRendering();
        }
        private function enterframeHandler(e : Event) : void 
        {
            cube.yaw(0.8);
            cube.pitch(0.4);
            cube.y = (CUBE_RANGE_H * Math.sin(getTimer() / 2000));
            var radian : Number = mouseX / stage.stageWidth * 360 * Math.PI / 180;
            var range : Number = mouseY / stage.stageHeight;
            camera.x += (CAMERA_POSITION * Math.sin(radian) - camera.x) * .1;
            camera.z += (CAMERA_POSITION * Math.cos(radian) - camera.z) * .1;
            camera.y += (CAMERA_POSITION * range - camera.y) * .1;
            light.x = LIGHT_POSITION * Math.sin(getTimer() / 2000);
            light.z = LIGHT_POSITION * Math.cos(getTimer() / 2000);
            light.y = LIGHT_POSITION * 1;
        }
    }
}
