/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j2Aq
 */

/**
 * @author Esukei
 * 2010-08-28 for Tokyo Teraco7
 * Effect Sample 'Before'
 */
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(backgroundColor="#000000",frameRate=30)]
    public class EffectSample extends Sprite {
        
        private var circles:Array;
        private var counter:uint = 0;
        
        public function EffectSample() {
            // write as3 code here..
            
            circles = new Array();
            addEventListener(Event.ENTER_FRAME,function(e:Event):void
            {
                if(counter == 3)
                {
                    counter = 0;
                    circles.push(new CircleEffect());
                    circles[circles.length - 1].x = stage.stageWidth / 2;
                    circles[circles.length - 1].y = stage.stageHeight / 2;
                    addChild(circles[circles.length - 1]);
                    circles[circles.length - 1].addEventListener(Event.COMPLETE,function(ee:Event):void{
                        removeChild(CircleEffect(ee.target));
                        CircleEffect(ee.target).removeEventListener(Event.COMPLETE, arguments.callee);
                        delete CircleEffect(ee.target);
                    });
                }
                else
                {
                    counter++;
                }
            });
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
class CircleEffect extends Sprite {
    
    private var lifeTime:uint;
    private var targetScale:Number;
    private var counter:uint = 0;
    
    public function CircleEffect()
    {
        lifeTime = 15 + uint(30 * Math.random());
        targetScale = 0.4 + 0.8 * Math.random();
        addEventListener(Event.ENTER_FRAME, effect);
        graphics.beginFill(Math.random() * 0xFFFFFF,1.0);
        graphics.drawCircle(0, 0, 200);
        graphics.endFill();
        scaleX = scaleY = 0.0;
    }

    public function effect(e:Event):void
    {
        if(counter > lifeTime)
        {
            removeEventListener(Event.ENTER_FRAME, effect);
            dispatchEvent(new Event(Event.COMPLETE));
        }
        else
        {
            counter++;
            scaleX = scaleY = targetScale * counter / lifeTime;
        }
    }
}
