/**
 * Copyright 9balls ( http://wonderfl.net/user/9balls )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j27f
 */

package {
    import com.bit101.components.InputText;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.bit101.components.RadioButton;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Stage3D;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display3D.Context3D;
    import flash.display3D.Context3DRenderMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.utils.getTimer;

    /**
     * ...
     * @author
     */
    public class Main extends Sprite {
        //
        private var stage3D:Stage3D;
        private var context3D:Context3D
        private var widthInput:InputText;
        private var heightInput:InputText;
        private var radio0:RadioButton;
        private var radio1:RadioButton;
        private var radio2:RadioButton;
        private var destBd:BitmapData;
        private var resultTf:TextField;

        public function Main():void {
            stage.frameRate = 60;
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            //
            stage3D = stage.stage3Ds[0];
            stage3D.addEventListener(Event.CONTEXT3D_CREATE, onContextCreate);
            stage3D.requestContext3D(Context3DRenderMode.AUTO);
        }

        private function onContextCreate(e:Event):void {
            context3D = stage3D.context3D;
            var driver:TextField = new TextField();
            driver.autoSize = TextFieldAutoSize.LEFT;
            driver.y = 400;
            driver.text = context3D.driverInfo;
            addChild(driver);
            //
            new Label(this, 10, 80, "width : ");
            widthInput = new InputText(this, 50, 80, "800");
            widthInput.width = 40;
            widthInput.restrict = "0-9";
            widthInput.maxChars = 4;
            new Label(this, 110, 80, "height : ");
            heightInput = new InputText(this, 150, 80, "600");
            heightInput.width = 40;
            heightInput.restrict = "0-9";
            heightInput.maxChars = 4;
            radio0 = new RadioButton(this, 80, 120, "single", true);
            radio1 = new RadioButton(this, 80, 140, "single with clear() call", false);
            radio2 = new RadioButton(this, 80, 160, "100 times", false);
            var radio3:RadioButton = new RadioButton(this, 80, 180, "100 times with each clear() calls", false);
            new PushButton(this, 80, 220, "drawToBitmapData", onPush);
            //
            resultTf = new TextField();
            resultTf.autoSize = TextFieldAutoSize.LEFT;
            resultTf.x = 80;
            resultTf.y = 240;
            addChild(resultTf);
        }

        private function onPush(e:MouseEvent):void {
            var w:uint = uint(widthInput.text);
            if (w < 50){
                w = 50;
                widthInput.text = "50";
            } else if (w > 2048){
                w = 2048;
                widthInput.text = "2048";
            }
            var h:uint = uint(heightInput.text);
            if (h < 50){
                h = 50;
                heightInput.text = "50";
            } else if (h > 2048){
                h = 2048;
                heightInput.text = "2048";
            }
            destBd = new BitmapData(w, h);
            context3D.configureBackBuffer(w, h, 0, true);
            //
            if (radio0.selected){
                single();
            } else if (radio1.selected){
                single2();
            } else if (radio2.selected){
                multi();
            } else {
                multi2();
            }
            destBd.dispose();
        }

        private function single():void {
            context3D.clear();
            var start:int = getTimer();
            context3D.drawToBitmapData(destBd);
            resultTf.text = (getTimer() - start) + " ms";
        }

        private function single2():void {
            var start:int = getTimer();
            context3D.clear();
            context3D.drawToBitmapData(destBd);
            resultTf.text = (getTimer() - start) + " ms";
        }

        private function multi():void {
            context3D.clear();
            var start:int = getTimer();
            for (var i:int = 0; i < 100; i++){
                context3D.drawToBitmapData(destBd);
            }
            resultTf.text = ((getTimer() - start) / 100) + " ms";
        }

        private function multi2():void {
            var start:int = getTimer();
            for (var i:int = 0; i < 100; i++){
                context3D.clear();
                context3D.drawToBitmapData(destBd);
            }
            resultTf.text = ((getTimer() - start) / 100) + " ms";
        }

    }
}