/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j1UV
 */

package 

{

    

    import flash.display.Sprite;

    import flash.events.ActivityEvent;

    import flash.events.Event;

    import flash.events.SampleDataEvent;

    import flash.media.Microphone;

    import flash.utils.ByteArray;

    import nape.geom.AABB;

    import nape.geom.Vec2;

    import nape.phys.Body;

    import nape.phys.BodyType;

    import nape.phys.Material;

    import nape.shape.Circle;

    import nape.shape.Polygon;

    import nape.space.Space;

    import nape.util.BitmapDebug;

    import nape.util.Debug;

    /**

     * ...

     * @author umhr

     */

    public class Canvas extends Sprite 

    {

        private var _microphone:Microphone;

        private var _stageWidth:int;

        private var _stageHeight:int;

        // nape

        private var _ballList:Array/*Body*/ = [];

        private var _kugiList:Array/*Body*/ = [];

        private var space:Space;

        private var debug:Debug;

        public function Canvas() 

        {

            init();

        }

        private function init():void 

        {

            if (stage) onInit();

            else addEventListener(Event.ADDED_TO_STAGE, onInit);

        }



        private function onInit(event:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, onInit);

            // entry point

            

            _stageWidth = stage.stageWidth;

            _stageHeight = stage.stageHeight;

            

            _microphone = Microphone.getMicrophone();

            if (_microphone) {

                _microphone.setSilenceLevel(10, 0);

                _microphone.rate = 8;

            }

            

            _microphone.addEventListener(SampleDataEvent.SAMPLE_DATA, microphone_sampleData);

            

            setNape();

            

            addEventListener(Event.ENTER_FRAME, enterFrame);

        }

        

        private function setNape():void 

        {

            var gravity:Vec2 = Vec2.weak(0, 600);

            space = new Space(gravity);

            debug = new BitmapDebug(_stageWidth, _stageHeight);

            addChild(debug.display);

            

            var n:int = 24;

            for (var i:int = 0; i < n; i++) {

                var ball:Body = new Body(BodyType.DYNAMIC);

                ball.shapes.add(new Circle(10,null,new Material(1.5)));

                ball.position.setxy(i * _stageWidth / n, 0);

                ball.space = space;

                _ballList.push(ball);

            }

            

        }

        

        private function microphone_sampleData(e:SampleDataEvent):void 

        {

            

            var byteArray:ByteArray = e.data;

            

            var n:int = byteArray.length * 0.25;// 256;// Math.min(256, byteArray.length * 0.25);

            n = Math.min(256, n);

            for (var i:int = 0; i < n; ++i)

            {

                var tx:Number = i / n * _stageWidth;

                var ty:Number = _stageHeight * 0.7 - byteArray.readFloat() * 400;

                

                if (i%8 == 0) {

                    if(!_kugiList[i]){

                        var kugi:Body = new Body(BodyType.KINEMATIC);

                        kugi.shapes.add(new Polygon(Polygon.rect( 0, 0, 15, 15)));

                        kugi.rotation = (45) * Math.PI / 180;

                        kugi.space = space;

                        _kugiList[i] = kugi;

                    }

                    _kugiList[i].position.setxy(tx, ty);

                }

            }

        }

        

        private function enterFrame(e:Event):void 

        {

            space.step(1 / stage.frameRate);

            var n:int = _ballList.length;

            for (var i:int = 0; i < n; i++) 

            {

                var ball:Body = _ballList[i];

                if (ball.position.y > _stageWidth) {

                    ball.position.x = i * _stageWidth / n;

                    ball.position.y = 0;

                    ball.velocity.y = 0;

                    ball.velocity.x = -ball.velocity.x;

                }

            }

            

            debug.clear();

            debug.draw(space);

            debug.flush();

        }

        

    }

    

}