/**
 * Copyright aiz ( http://wonderfl.net/user/aiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j1P1
 */

// forked from hacker_yk666qry's 軌跡
//010309
package {
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    
    /**
     * ...
     * @author ...
     */
    [SWF(width="465",height="465",backgroundColor="0x666666",frameRate="30")]
    public class WonderflBook extends Sprite {
        
        private var _ball:Sprite;
        private var _locus:Sprite;
        private var _timeGage:Sprite;
        
        private var _animFrames:Array;
        private var _startX:Number = 0;
        private var _startY:Number = stage.stageHeight / 2;
        private var _endX:Number = stage.stageWidth;
        private var _frameCount:uint = 0;
        private var _frameCountLimit:uint = 150;
        
        private var _format:TextFormat;
        private var _tf:TextField;
        
        //コンストラクタ
        public function WonderflBook() {
            //初期化
            init();
        }
        
        public function init():void{//初期化メソッド
            _animFrames=generateAnimFrames();//アニメーションフレームの生成
            
            _format = new TextFormat();
            _format.color = 0xffffff;
            
            _tf = new TextField();
            _tf.defaultTextFormat = _format;
            //_tf.width = 465;
            _tf.autoSize = TextFieldAutoSize.LEFT;
            _tf.wordWrap = true;
            _tf.text = _animFrames.toString();
            addChild(_tf);
                
                
                
            _ball=new Sprite();//画面に表示される_ball用Sprite
            _ball.graphics.lineStyle(1, 0xffffff);
            _ball.graphics.beginFill(0xffffff);
            _ball.graphics.drawCircle(0, 0, 20);
            _ball.graphics.endFill();
            
            _timeGage=new Sprite();//画面下部のゲージ用Sprite
            _timeGage.graphics.beginFill(0xFFFFFF,0.5);
            _timeGage.graphics.drawRect(0,0,stage.stageWidth,10);
            _timeGage.graphics.endFill();
            _timeGage.x=0;
            _timeGage.y=stage.stageHeight-10;
            
            _locus=new Sprite();//軌跡表示用Sprite
            
            //_ball.blendMode=BlendMode.ADD;
            _ball.filters=[new GlowFilter(0x00FFFF,1,16,16)];
            
            addChild(_locus);
            addChild(_timeGage);
            addChild(_ball);//_ballをDisplayTreeへ登録
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN,startRec);
            stage.addEventListener(MouseEvent.MOUSE_UP,stopRec);
            
            updateLocus();//軌跡の初期化
            
            start();//レンダリング開始
        }
        
        private function generateAnimFrames():Array{//アニメーションフレームを生成するメソッド
            var tmp:Array=new Array();//出力用の一時的な配列
            var easeRatio:Number=0.2;//イージングの比率
            var tmpX:Number=_startX;
            var tmpY:Number=_startY;
            for(var i:uint=0; i<_frameCountLimit; i++){
                tmpX+=(_endX-tmpX)*easeRatio;
                tmp.push(new Point(tmpX,tmpY));//各コマのx座標,y座標をコマ数だけ計算して配列に追加
            }
                
            return tmp;
        }
        
        public function start():void {
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        public function stop():void {
            removeEventListener(Event.ENTER_FRAME, render);
        }
        
        //レンダリングメソッド
        public function render(event:Event):void {
            if (_frameCount < _frameCountLimit) {
                //_ballのx(y)に今のコマ数の座標を代入
                _ball.x = _animFrames[_frameCount].x;
                _ball.y = _animFrames[_frameCount].y;
            } else {
                _frameCount = 0;
            }
            _timeGage.width = (_frameCount / _frameCountLimit) * stage.stageWidth;
            _frameCount++;
        }
        
        
        public function startRec(event:Event):void {
            addEventListener(Event.ENTER_FRAME, recMouse);
        }
        
        public function stopRec(event:Event):void {
            removeEventListener(Event.ENTER_FRAME, recMouse);
        }
        
        //マウスの位置記録メソッド
        public function recMouse(event:Event):void {
            if (_frameCount < _frameCountLimit) {
                _animFrames[_frameCount].x = mouseX;
                _animFrames[_frameCount].y = mouseY;
                updateLocus(); //軌跡を再描画
            }
        }
    
        //軌跡再描画メソッド
        public function updateLocus():void {
            _locus.graphics.clear();
            _locus.graphics.lineStyle(1, 0xffffff, 0.2); //線の太さ, 色, アルファ
            for (var i:uint = 0; i < _frameCountLimit; i++) {
                _locus.graphics.drawCircle(_animFrames[i].x, _animFrames[i].y, 20);
            }
        }
    }
}