/**
 * Copyright techx ( http://wonderfl.net/user/techx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/j0gj
 */

// forked from andres_works's particle smoke!!
package 
{
    import caurina.transitions.Tweener;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    /**
     * ...クリックで拡大！
     * @author ta-ta
     */
    [SWF(width = 465, height = 465, backgroundColor = 0, frameRate = 30)]
    public class Main extends Sprite 
    {
        private static const R:Number = 0.017453;
        public var ms:Number = 0.1;
            
        private var
            clen    :int                = 20000,
            tlen    :int                = 720,
            ct      :Vector.<Number>    = new Vector.<Number>(tlen, true),
            st      :Vector.<Number>    = new Vector.<Number>(tlen, true),
            cvs     :BitmapData         = new BitmapData(465, 465, false, 0),
            ctf     :ColorTransform     = new ColorTransform(),
            cmfArr  :Array              = [1.11, 0, 0, 0, -45, 0, 1.1, 0, 0, -28, 0, 0, 1.12, 0, -45],
            cmf     :ColorMatrixFilter  = new ColorMatrixFilter(cmfArr),
            bf      :BlurFilter         = new BlurFilter(2, 2),
            cp      :Point              = new Point(),
            vp      :Point              = new Point(),
            img     :BitmapData,
            top     :Circle;
        
        public function Main():void 
        {
            initsourceImage();
            initAngleTable();
            initCircle();
            addChild(new Bitmap(cvs));
            
            stage.addEventListener(Event.ENTER_FRAME    , update);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mdh);
            //stage.addEventListener(MouseEvent.MOUSE_MOVE  , muh);
        }
        
        private function initsourceImage():void
        {
            var _s:Shape = new Shape();
            _s.graphics.beginFill(0xFF0000+Math.random());
            _s.graphics.drawCircle(8, 8, 6);
            _s.graphics.endFill();
            _s.filters = [new BevelFilter(8, 45, 0x10F04F, 0.6, 0, 0.6)];
            img = new BitmapData(16, 16, true, 0);
            img.draw(_s);
        }
        
        private function initAngleTable():void 
        {
            var _base:Number = 360 / 720;
            
            for (var i:int = 0; i < 720; i++) 
            {
                ct[i] = Math.cos(R * _base * i);
                st[i] = Math.sin(R * _base * i);
            }
        }
        
        private function initCircle():void
        {
            top = new Circle(Math.random() * 525, Math.random() * 20 - 5, Math.random() * 10 - 5, null);
            for (var i:int = clen - 2; 0 <= i; i--) top = new Circle(Math.random() * 719, Math.random() * 30 - 15, Math.random() * 10 - 5, top);
        }
        
        public function update(e:Event):void
        {
            var
                _r:Number,
                _a:int,
                _px:Number = 232.5,
                _py:Number = 232.5,
                _vp:Point = vp,
                _cvs:BitmapData = cvs,
                _img:BitmapData = img,
                _cvsRect:Rectangle = _cvs.rect,
                _imgRect:Rectangle = _img.rect;
                
            _cvs.lock();
            for (var _circle:Circle = top; _circle; _circle = _circle.next)
            {
                _circle.update();
                
                _r = _circle.radius/2;
                _a = _circle.angleIndex;
                _px += ct[_a] * _r * ms;
                _py += st[_a] * _r * ms;
                _vp.x = _px - 8;
                _vp.y = _py - 8;
                
                if (_vp.x > 473 || _vp.x < -8 || _vp.y > 473 || _vp.y < -8) continue;
                _cvs.copyPixels(_img, _imgRect, vp, null, null, true);
            }
            _cvs.applyFilter(_cvs, _cvsRect, cp, cmf);
            //_cvs.applyFilter(_cvs, _cvsRect, cp, bf);
            _cvs.unlock();
        }
        
        
        private function mdh(e:MouseEvent):void
        {
            Tweener.addTween(this, {ms:Math.floor(Math.random()*4)+.1, time:3, transition:"easeOutBack"})
        }
        
        private function muh(e:MouseEvent):void
        {
            Tweener.addTween(this, {ms:0.1, time:3, transition:"easeOutBack"})
        }
        
    }
    
}

class Circle
{
    public var
        radius:Number,
        angleIndex:int,
        next:Circle;
        
    private var aii:int;
        
    public function Circle(
        angleIndex:int,
        radius:Number,
        aii:int,
        next:Circle)
    {
        this.angleIndex = angleIndex;
        this.radius     = radius;
        this.aii        = aii;
        this.next       = next;
    }
    
    public function update():void
    {
        angleIndex += aii;
        if (angleIndex <= 0) angleIndex = 719;
        if (angleIndex >= 720) angleIndex = 0;
    }
}
