/**
 * Copyright windy ( http://wonderfl.net/user/windy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/izUI
 */

// forked from windy's forked from: マイク対応SoundVisualizer
// forked from ikke's マイク対応SoundVisualizer
/**
* マイク入力に対応させてみた。
*    
* 音は http://shw.in/sozai/ を使わせていただきました。 
*/
package {
    import com.bit101.components.PushButton;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.SampleDataEvent;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.media.Microphone;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;

    public class SoundTest extends Sprite
    {
        private var SIZE:int = 300;
        private var _canvas:BitmapData;
        
        private var _sound:Sound;
        private var _soundMixier:SoundMixer;
        private var _soundChannel:SoundChannel;
        
        private var _ctfm:ColorTransform;
        private var _bytes:ByteArray = new ByteArray();
        private var _particles:Array = [];
        private var _angle:Number = 0;
        private var _sw:Number;
        private var _sh:Number;
        
        private var _mic:Microphone;
        private var _btnMic:PushButton;
        private var _btnFile:PushButton;
        private var _useMic:Boolean;
        
        private var _blur:BlurFilter = new BlurFilter(3,3,1);
        private var _glow:GlowFilter = new GlowFilter();
        
        public function SoundTest()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.frameRate =  30;
            _sw = stage.stageWidth;
            _sh = stage.stageHeight;

            var baseBmd:BitmapData = new BitmapData(_sw, _sh, false, 0 );
            addChild( new Bitmap( baseBmd ) );
            
            _canvas = new BitmapData( _sw, _sh, true, 0x66666666 );
            var bmp:Bitmap = new Bitmap( _canvas );
            bmp.blendMode = BlendMode.ADD;
            
            addChild( bmp );
            
            _btnMic = new PushButton();
            _btnMic.x = _sw /2 - _btnMic.width - 10;
            _btnMic.y = ( _sh - _btnMic.height ) / 2;
            _btnMic.label = "USE MIC";
            addChild( _btnMic );
            _btnMic.addEventListener(  MouseEvent.CLICK, micClickHandler );
            _btnFile = new PushButton();
            _btnFile.x = _sw / 2 + 10;
            _btnFile.y = _btnMic.y;
            addChild( _btnFile );
            _btnFile.addEventListener( MouseEvent.CLICK, fileClickHandler );
            
            _ctfm = new ColorTransform();
            _ctfm.alphaMultiplier = .1;
            _ctfm.redMultiplier = .9;
            _ctfm.blueOffset = 10;
        }
        
        private function micClickHandler( e:MouseEvent ):void
        {
            _useMic = true;
            removeChild( _btnMic );
            removeChild( _btnFile );
            
            _mic = Microphone.getMicrophone();
            _mic.rate = 44;
            _mic.addEventListener( SampleDataEvent.SAMPLE_DATA,
                function( e:SampleDataEvent )
                {
                    _bytes = e.data;
                } );
            
            addEventListener( Event.ENTER_FRAME, draw );
        }
        
        private function fileClickHandler( e:MouseEvent ):void
        {
            _useMic = false;
            removeChild( _btnMic );
            removeChild( _btnFile );
            
            _sound = new Sound();
            _sound.addEventListener( Event.COMPLETE,
                function()
                {
                    _soundChannel = _sound.play();
                    var stfm:SoundTransform = new SoundTransform();
                    _soundChannel.soundTransform = stfm;
                    addEventListener( Event.ENTER_FRAME, draw );
                    _sound.removeEventListener( Event.COMPLETE, arguments.callee );
                } );
            Security.loadPolicyFile( "http://psalms.weblike.jp/crossdomain.xml" );
            _sound.load( new URLRequest("http://psalms.weblike.jp/sound/u-chi-u.mp3" ) );
        }
        
        private function draw(e:Event):void
        {
            _angle += .005;
            _canvas.colorTransform( _canvas.rect, _ctfm);
            _canvas.lock();
            var n:Number = 0;
            var size:Number = 0;
            
            if( !_useMic )    SoundMixer.computeSpectrum( _bytes, false, 0 );
            _bytes.position = 0;
            
            var _bytesLength:int = _bytes.length / 4;
            if( _useMic )    _bytesLength /= 10;
            else    _bytesLength /= 5;
            
            for (var i:int = 0; i < _bytesLength; i++)
            {
                var float:Number = _bytes.readFloat();
                n = ( float + 1) / 2;
                
                size = n * SIZE;
                
                
                var l:Number = (size/2)*Math.PI;
                var interval:Number = l / 360 * 10;
                if( interval == 0 )
                {
                    return;
                }
                
                interval = Math.abs(2 * ( Math.sin(_angle)) )+ 2;

                for( var j:Number = 0; j <= l; j+= interval )
                {
                    var x:Number = size/2 * Math.sin( j );
                    var y:Number = size/2 * Math.cos( j );
                    if( x == 0 ) continue;
                    
                    if( n <= .8 )    _canvas.setPixel32( x + _sw/2, y + _sh/2, 0xffffffff );
                    
                    if( n >= .8 && _particles.length <= size/3)
                    {
                        var p:Particle = new Particle(x + _sw/2, y + _sh/2, n, 0xffff0066, _canvas );
                        _particles.push( p );
                    }
                }
                
                
                for( var k:int = 0; k < _particles.length; k++ )
                {
                    p = _particles[ k ];
                    if( p != null )
                    {
                        p.update();
                        if( p.isEnd )    _particles.splice( k, 1 );
                    }
                }
            }
            
            _canvas.unlock();
            _canvas.applyFilter( _canvas, _canvas.rect, new Point(), _blur );
            _canvas.applyFilter( _canvas, _canvas.rect, new Point(), _glow );
        }
        
    }
}

import flash.display.BitmapData;
import flash.events.EventDispatcher;
import flash.events.Event;

class Particle
{
    private var vx:Number = 0;
    private var vy:Number = 0;
    private var x:Number = 0;
    private var y:Number = 0;
    private var col:uint;
    private var bmd:BitmapData;
    private var limit:int = 0;
    public var isEnd:Boolean = false;
    private var max:int = 0;
    
    public function Particle(x:Number,y:Number, sp:Number, col:uint, bmd:BitmapData):void
    {
        this.x = x;
        this.y = y;
        this.col = col;
        max  = 1000 * sp;
        vx = ( Math.random() -.5 )/15 * sp;
        vy = ( Math.random() -.5 )/15 * sp;
        this.bmd = bmd;
    }
    
    public function update( ):void
    {
        x += vx;
        y += vy;
        bmd.setPixel32( x, y, col );
        limit+=1;
        if( limit >= max )    isEnd = true;
    }
}