/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/izUF
 */

/*

こちらを参照させて頂きました。 → ParticleEffect2(http://wonderfl.net/c/feei)

勉強を兼ねて自分が分かりやすいように書き直してみました。

*/

package {
    import com.flashdynamix.motion.easing.ElasticEaseParams;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.ColorMatrixFilter;
    import flash.net.*;
    import flash.system.*;
    import flash.utils.*;
    import flash.geom.*;
    import org.ascollada.core.DaeAsset;

    [SWF(width="465",height="465",backgroundColor="0xFFFFFF",frameRate="45")]

    public class Main extends Sprite {
        public var canvas:BitmapData;
        public var canvasBM:Bitmap;
        public var textCanvas:BitmapData;
        public var textBM:Bitmap;
        public var textMake:TextMake;

        public var startPoint:Point;

        public var particleArray:Array;

        public var W:Number=stage.stageWidth;
        public var H:Number=stage.stageHeight;

        public var timer:Timer;
        public var lastTimer:Timer;


        public function Main( ) {
            init( );
        }

        public function init( ):void {
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;
            stage.quality=StageQuality.LOW;


            textMake=new TextMake(80,0x0C6Ed8,"Arial","HELLO");
            //テキストキャンバス
            textCanvas=new BitmapData(textMake.width,textMake.height,true,0xFFFFFFFF);
            textCanvas.draw(textMake);
            
            //背景キャンバス
            canvas=new BitmapData(W,H,true,0xFFFFFFFF);
            canvasBM=new Bitmap(canvas);
            addChild(canvasBM);
            
            particleArray=new Array();
            //スタートポイント取得しておく
            startPoint=new Point(Math.floor((W-textMake.width)/2),Math.floor((H-textMake.height)/2));
            
            pixelPicker();
            
            timer=new Timer(10);
            timer.addEventListener(TimerEvent.TIMER,onRender);
            timer.start();

        }
        
        //ピクセルの色を取得してパーティクルを作成する
        public function pixelPicker():void {
            
            for (var px:int=0; px<=textMake.width; px++) {
                for (var py:int=0; py<=textMake.height; py++) {
                    var col:uint=textCanvas.getPixel32(px,py);
                    if (col!=0xffffffff && col!=0x00000000 ) {
                        var rx:Number=textMake.width-px;
                        var ry:Number=textMake.height-py;
                        var dist:Number=Math.floor((Math.sqrt((rx*rx)+(rx*ry))));//左側から先に落ちてくるようにする
                        particleArray.push(new Particle(Math.ceil(10000*Math.random())+5000,startPoint.y-Math.ceil(10000*Math.random())-1000,px+startPoint.x,py+startPoint.y,dist,col));
                    }
                }
            }
            lastTimer = new Timer(10, particleArray.length);
            lastTimer.addEventListener(TimerEvent.TIMER,onRender);
        }


        public function onRender(e:TimerEvent):void {
        
            canvas.lock();

            var current:Particle;

            var diffX:Number;
            var diffY:Number;
            var vX:Number;
            var vY:Number;
            
            var completeCount:int=0;

            for (var i:int=0; i<particleArray.length; i++) {

                current=particleArray[i];
                
                diffX=current.tx-current.x;
                diffY=current.ty-current.y;
                
                vX = diffX*0.5*(current.dist*0.003);
                vY =( diffY * 0.3)*(current.dist*0.003);
                
                //ゴールの座標との差が1px未満かどうか
                if (Math.abs(diffX)<1) {
                    current.x=current.tx;
                } else {
                    current.x+=vX;
                }
                
                if (Math.abs(diffY)<1) {
                    current.y = current.ty;                
                } else {
                    current.y+=vY;
                }
                
                 //全てのピクセルがセットされたら最後のタイマーをスタートさせる（ここでストップさせると残像が残ったまま終わってしまうので残像を消す為に最後のループ処理を行う）
                if ((particleArray[i].x == particleArray[i].tx) && (particleArray[i].y == particleArray[i].ty) && (lastTimer.running!=true)) {
                        completeCount += 1;
                    if (completeCount==particleArray.length) {
                        timer.stop();
                        lastTimerStart();
                    }
                }        
                canvas.setPixel32( current.x, current.y, current.color );
            }
            canvas.unlock( );
            canvas.colorTransform( canvas.rect, new ColorTransform( 1, 1, 1, 1, 15, 15, 15 ) );


        }
        
         public function lastTimerStart():void {
                lastTimer.start();
            }
    

    }
}





//パーティクルクラス
class Particle {
    public var tx:Number=0;//ゴール座標
    public var ty:Number=0;//ゴール座標
    public var x:Number=0;//現在地
    public var y:Number=0;//現在地
    public var dist:Number=0;//重力
    public var color:int = 0;

    public function Particle( x:Number, y:Number, gx:Number,gy:Number,dist:Number,color:int ) {
        this.tx=gx;
        this.ty=gy;
        this.x=x;
        this.y=y;
        this.dist=dist;
        this.color = color;
    }
    
}


//テキストクラス
import flash.display.*;
import flash.text.*;

class TextMake extends Sprite {

    public function TextMake(size:Number,col:uint,font:String,word:String) {

        init(size,col,font,word);
    }

    public function init(size:Number,col:uint,font:String,word:String):TextField {
        var tf:TextField = new TextField();
        var format:TextFormat = new TextFormat();
        format.size=size;
        format.color=col;
        format.font=font;
        tf.defaultTextFormat=format;
        tf.autoSize=TextFieldAutoSize.LEFT;
        tf.text=word;
        addChild(tf);
        return tf;
    }
}

