/**
 * Copyright IPFix ( http://wonderfl.net/user/IPFix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/izCo
 */

package 
{
    import alternativ7.engine3d.materials.TextureMaterial;
    import alternativ7.engine3d.primitives.Box;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Point;
    
    public class Main extends Sprite 
    {
        private var verticalSpace:int;
        private var horizontalSpace:int;
        private var bitmap:Bitmap;
        private var coeff:Number;
        private var speed:Number;
        private var bd:BitmapData;
        private var scene:AlternativaTemplate;
        private var box:Box;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            bitmap = new Bitmap();
            addChild(bitmap);
            coeff = 11;
            speed = .25;
            addEventListener(Event.ENTER_FRAME, everyFrame);        
            stage.addEventListener(Event.RESIZE, onResize);
            onResize(null);
            
            
            scene = new AlternativaTemplate(this, AlternativaTemplate.ZSORT);
            box = new Box(250,250,250);
            box.alpha = .4;
            scene.container.addChild(box);
            scene.startRendering();

        }
        
        private function onResize(e:Event):void 
        {
            bd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
        }
        
        private function everyFrame(e:Event):void 
        {
            verticalSpace = Math.abs(mouseX/stage.stageWidth * 50) +3;
            horizontalSpace = 3//Math.abs(mouseY/stage.stageWidth * 50)+3 ;
            coeff += speed;
            if (coeff >= 30 ||coeff <=10)
                speed = -speed;
            
            bd.lock()
            for (var i:int = 0; i < stage.stageWidth; i+=horizontalSpace) {
                for (var j:int = 0; j < stage.stageHeight; j += verticalSpace) {
                    if(Math.cos(i/coeff-mouseX/coeff)<0&&Math.sin(j/coeff-mouseY/coeff)>0)
                    bd.setPixel(i, j, 0xFFFFFF);
                }
            }
            bd.unlock();
            bd.applyFilter(bd, bd.rect, new Point(), new ColorMatrixFilter([.98, 0, 0, 0,
                                                                            0, .99, 0, 0,
                                                                            0, 0, .95, 0,
                                                                            0, 0, 0, .98]));
            bd.applyFilter(bd, bd.rect, new Point(), new BlurFilter(4, 4, 1));
            
            box.setMaterialToAllFaces(new TextureMaterial(bd, false, true, 0, 1));
            box.rotationZ += Math.PI/120;
            box.rotationY += Math.PI / 120;
            bitmap.bitmapData = bd;
        }
        
    }
    
}
  
    /**
     * BasicTemplate for Alternativa3D 7.6
     * Alternativa3D 7.6
     * @author narutohyper & clockmaker
     */
    import alternativ7.engine3d.containers.BSPContainer;
    import alternativ7.engine3d.containers.ConflictContainer;
    import alternativ7.engine3d.containers.DistanceSortContainer;
    import alternativ7.engine3d.containers.KDContainer;
    import alternativ7.engine3d.containers.LODContainer;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.View;
    import flash.display.DisplayObject;

    import flash.display.DisplayObjectContainer;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;

    import flash.events.Event;

    class AlternativaTemplate extends Sprite
    {
        public static const CONFLICT:String = 'conflict';
        public static const BSP:String = 'bsp';
        public static const ZSORT:String = 'zsort';
        public static const KD:String = 'kd';
        public static const LOD:String = 'lod';

        public var container:Object3DContainer;

        public var view:View;
        public var camera:Camera3D;
        public var cameraController:SimpleObjectController;

        private var _mc:DisplayObjectContainer;
        private var _viewWidth:int;
        private var _viewHeight:int;
        private var _scaleToStage:Boolean;
        private var _containerType:String;

        /**
         * 新しい Alternativa3DTemplate インスタンスを作成します。
         * @param    mc
         * @param    containerType
         * @param    viewWidth
         * @param    viewHeight
         * @param    scaleToStage
         */
        public function AlternativaTemplate(mc:DisplayObjectContainer,containerType:String=CONFLICT,viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true)
        {

            _mc = mc;
            _mc.addChild(this);

            _containerType = containerType;
            _viewWidth = viewWidth;
            _viewHeight = viewHeight;
            _scaleToStage = scaleToStage;

            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        protected function atInit():void {}
        protected function atPreRender():void {}
        private var _onPreRender:Function = function():void{};
        public function get onPreRender():Function { return _onPreRender; }
        public function set onPreRender(value:Function):void
        {
            _onPreRender = value;
        }
        protected function atPostRender():void {}
        private var _onPostRender:Function = function():void{};
        public function get onPostRender():Function { return _onPostRender; }
        public function set onPostRender(value:Function):void
        {
            _onPostRender = value;
        }

        public function startRendering():void
        {
            addEventListener(Event.ENTER_FRAME, onRenderTick);
        }
        public function stopRendering():void
        {
            removeEventListener(Event.ENTER_FRAME, onRenderTick);
        }
        public function singleRender():void
        {
            onRenderTick();
        }
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.HIGH;

            if (_containerType == CONFLICT) {
                container = new ConflictContainer();
            } else if (_containerType == BSP) {
                container = new BSPContainer();
            } else if (_containerType == ZSORT) {
                container = new DistanceSortContainer();
            } else if (_containerType == KD) {
                container = new KDContainer();
            } else if (_containerType == LOD) {
                container = new LODContainer();
            }
            //View
            view = new View(stage.stageWidth, stage.stageHeight);
            view.hideLogo();
            
            _mc.addChild(view);
            
            //camera
            camera = new Camera3D();
            camera.view = view;
            camera.x = 0;
            camera.y = -500;
            camera.z = 0;
            container.addChild(camera);
            //camera.view.showLogo();
            // Camera controller
            //cameraController = new SimpleObjectController(stage, camera, 10);
            //cameraController.mouseSensitivity = 0;
            //cameraController.unbindAll();
            //cameraController.lookAtXYZ(0, 0, 0);
           // _mc.addChild(camera.diagram);
            camera.rotationX = -130*Math.PI/180;
            camera.y = -400;
            camera.z = 350;
            
            onResize();
            stage.addEventListener(Event.RESIZE, onResize);
            atInit();
        }

        private function onResize(e:Event = null):void
        {
            if (_scaleToStage)
            {
                view.width = stage.stageWidth;
                view.height = stage.stageHeight;
            }
            else
            {
                view.width = _viewWidth;
                view.height = _viewHeight;
            }
        }

        private function onRenderTick(e:Event = null):void
        {
            atPreRender();
            _onPreRender();
            //cameraController.update();
            camera.render();
            atPostRender();
            _onPostRender();
        }
    }
