/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iytL
 */

/**
 * copyright (c) 2012 www.romatica.com
 * @author itoz
 */
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import away3d.containers.View3D;
    import away3d.core.base.SubGeometry;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.lights.PointLight;
    import away3d.materials.ColorMaterial;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.materials.methods.HardShadowMapMethod;
    import away3d.primitives.PlaneGeometry;

    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.getTimer;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    
    /**
     * 
     */
    public class PointLightSample2 extends View3D
    {
        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private static const FLOW_RANGE : int = 100;
        private static const FLOW_SPEED : Number = 3;
        private static const  RAD_VAR : Number = (Math.PI / 180);
        private static const RANGE : Number = 1500;
        private var _light : PointLight;
        private var _clothMat : ColorMaterial;
        private var _clothGeo : PlaneGeometry;
        private var _cloth : Mesh;
        private var _defs : Vector.<Number>;
        private var _angs : Vector.<Number>;
        
        //private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);
        

        public function PointLightSample2()
        {
            if(stage) _initialize(null); 
            else  addEventListener(Event.ADDED_TO_STAGE, _initialize);
        }

        private function _initialize(event : Event) : void
        {
        
        //addChild(new Bitmap(source)) ;
         
            removeEventListener(Event.ADDED_TO_STAGE, _initialize);
            backgroundColor = 0x0;
            camera.y = 1000;
            camera.lens.far = 6000;
            // ----------------------------------
            // ライト
            // ----------------------------------
            _light = scene.addChild(new PointLight()) as PointLight;
            _light.color = 0xfbff00;
            _light.y = 600;

            // ----------------------------------
            // 布
            // ----------------------------------
            _clothMat = new ColorMaterial(0xaab6b0);
            _clothMat.bothSides = true;
            _clothMat.shadowMethod = new HardShadowMapMethod(_light);
            _clothMat.lightPicker = new StaticLightPicker([_light]);
            _clothGeo = new PlaneGeometry(1024, 1024, 16, 16);
            _cloth = new Mesh(_clothGeo, _clothMat);
            _cloth.castsShadows = true;
            // _cloth.showBounds = true;
            scene.addChild(_cloth);

            // ----------------------------------
            // 揺らぎ用パラメータ
            // ----------------------------------
            var max : int = _cloth.geometry.subGeometries[0].vertexData.length;
            _defs = new Vector.<Number>(max);
            _angs = new Vector.<Number>(max);
            for (var i : int = 0; i < _defs.length; i++) {
                _defs[i] = _cloth.geometry.subGeometries[0].vertexData[i];
                _angs[i] = (360 / _defs.length * i );
            }

            addChild(new AwayStats());

            addEventListener(Event.ENTER_FRAME, update);
        }

        /**
         * アップデート
         */
        private function update(event : Event) : void
        {
            clothMotion();
            cameraMotion();
            // 描画
            render();
        }

        /**
         * 布頂点ゆらぎ
         */
        private function clothMotion() : void
        {
            var geo : SubGeometry = _clothGeo.subGeometries[0] as SubGeometry;
            var vlen : int = geo.vertexData.length;
            for (var i : int = 0; i < vlen;i++ ) {
                _angs[i] += (_angs[i] + FLOW_SPEED >= 360) ? FLOW_SPEED - 360 : FLOW_SPEED;
                var rad : Number = _angs[i] * RAD_VAR;
                var flow : int = Math.cos(rad) * FLOW_RANGE;
                geo.vertexData[i] = _defs[i] + flow;
            }
            geo.updateVertexData(geo.vertexData);
        }

        /**
         * カメラ移動
         */
        private function cameraMotion() : void
        {
            
            var t : Number = getTimer() / RANGE;
            camera.x = Math.sin(t) * RANGE;
            camera.y = Math.cos(t) * RANGE+RANGE/2;
            camera.z = Math.cos(t) * RANGE;
            camera.lookAt(ZERO);
            
            //renderer.queueSnapshot(source);
        }
    }
}
