/**
 * Copyright frankman ( http://wonderfl.net/user/frankman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iyK8
 */

// Jacobs Ladder
// Frank Cizmich   --  frank.urugate.com
package {
    import flash.display.*;
    import flash.filters.*;
    import flash.events.*;
    import flash.media.*;
    import flash.net.URLRequest;
    [SWF(width="465", height="465", frameRate="30", backgroundColor="0x000000")]
    public class JacobsLadder extends Sprite {
            public var SW:Number = 465;
            public var SH:Number = 465;

            public var spark:Sprite = new Sprite();

            public var wireAX1:Number = 0.4*SW;
            public var wireAY1:Number = 0.8*SH;
            public var wireAX2:Number = 0.2*SW;
            public var wireAY2:Number = 0.2*SH;

            public var wireBX1:Number = 0.6*SW;
            public var wireBY1:Number = 0.8*SH;
            public var wireBX2:Number = 0.8*SW;
            public var wireBY2:Number = 0.2*SH;

            public var sparkX1:Number = wireAX1;
            public var sparkY1:Number = wireAY1;
            public var sparkX2:Number = wireBX1;
            public var sparkY2:Number = wireBY1;

            public var spark_vertical_variability:Number = 30;
            public var spark_subdivisions:Number = 20;
    
            public var g:Graphics;

            public var snd:Sound;
            public var channel:SoundChannel;
            
        public function JacobsLadder() {
            // draw wires
            g = this.graphics;
            
            g.beginFill(0x000000);
            g.drawRect(0,0,465,465);
            g.endFill();
            
            g.lineStyle(6, 0xB87333, 1.0);
            g.moveTo(wireAX1, wireAY1);
            g.lineTo(wireAX2, wireAY2);
            g.moveTo(wireBX1, wireBY1);
            g.lineTo(wireBX2, wireBY2);

            spark.x = sparkX1;
            spark.y = sparkY1;
            addChild(spark);
            spark.filters = [new GlowFilter(0x0000FF,1.0, 20, 20, 3)];

            addEventListener(Event.ENTER_FRAME, redrawSpark);
            channel = new SoundChannel();
            var req:URLRequest = new URLRequest("http://frank.urugate.com/sounds/Electric2.mp3");
            snd = new Sound();
            snd.load(req);
            snd.play(65,999);
         }
        public function redrawSpark(e:Event):void {
            spark.x = sparkX1;
            spark.y = sparkY1;
            var subdivx:Number = (sparkX2 - sparkX1)/spark_subdivisions;
            g = spark.graphics;
            g.clear();
            var i:Number;
            var j:Number;
            g.lineStyle(3, 0xFFFFFF, 1.0);
            g.moveTo(0,0);
            var xpos:Number;
            var ypos:Number;
            for ( i=0; i<spark_subdivisions-1; i++ ) {
                xpos = (i+1)*subdivx;
                ypos = Math.random()*spark_vertical_variability-spark_vertical_variability/2;
                g.lineTo(xpos,ypos);
            }
            g.lineTo((i+1)*subdivx,0);
            moveSpark();
        }
        public function moveSpark():void {
            sparkY1 -= 9.0;
            if (sparkY1 < wireAY2) {
                sparkY1 = wireAY1;
            }
            sparkY2 = sparkY1;
            var dx:Number = (wireAY1 - sparkY1)*(wireAX1-wireAX2)/(wireAY1-wireAY2);
            sparkX1 = wireAX1-dx;
            sparkX2 = wireBX1+dx;
        }
    }
}