/**
 * Copyright yasurageruheya ( http://wonderfl.net/user/yasurageruheya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iyCL
 */

// forked from yasurageruheya's if 文と switch 文の条件比較回数とか
package {
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Rectangle;
	import flash.system.System;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.ByteArray;
	public class FlashTest extends Sprite {
		
		public const LOOP:int = 12500;
		
		public const txt:TextField = new TextField();
		
		public var tests:Vector.<Tester> = new Vector.<Tester>();
		
		public var freeMemory:int;
		
		public var gcCount10byte:int = 0;
		
		public var gcCount100byte:int = 0;
		
		public var gcCount1KB:int = 0;
		
		public var gcCount10KB:int = 0;
		
		public var gcCount100KB:int = 0
		
		public var gcCount1MB:int = 0;
		
		public var gcCount10MB:int = 0;
		
		public var gcCount100MB:int = 0;
		
		public var gcCount:int = 0;
		
		public var totalFrames:Number = 1;
		
		public function FlashTest() {
			
			
			tests[tests.length] = new Tester('String("00000" + i).substr( -5, 5)\t\t\t: ', function():void
			{
				stringCastTest();
			});
			
			tests[tests.length] = new Tester('("00000" + i).toString().substr( -5, 5)\t\t: ', function():void
			{
				toStringCast();
			});
			
			tests[tests.length] = new Tester('(("00000" + i) as String).substr( -5, 5)\t: ', function():void
			{
				asCast();
			});
			
			tests.reverse();
			var format:TextFormat = txt.getTextFormat();
			format.font = "_等幅";
			txt.defaultTextFormat = format;
			txt.width = 500;
			txt.height = 500;
			addChild(txt);
			
			freeMemory = System.freeMemory;
			
			// write as3 code here..
			addEventListener(Event.ENTER_FRAME, test);
		}
		
		private function test(e:Event):void 
		{
			var str:String = "";
			var i:int = tests.length;
			while (i--)
			{
				str += tests[i].start();
			}
			str += "\nmemory : total " + System.totalMemory + " / private " + System.privateMemory + "\n";
			
			const currentFreeMemory:Number = System.freeMemory;
			
			if (freeMemory < currentFreeMemory)
			{
				gcCount++;
				const gcMemory:Number = currentFreeMemory - freeMemory;
				if (gcMemory > 100000000)
				{
					gcCount100MB++;
				}
				else if (gcMemory > 10000000)
				{
					gcCount10MB++;
				}
				else if (gcMemory > 1000000)
				{
					gcCount1MB++;
				}
				else if (gcMemory > 100000)
				{
					gcCount100KB++;
				}
				else if (gcMemory > 10000)
				{
					gcCount10KB++;
				}
				else if (gcMemory > 1000)
				{
					gcCount1KB++;
				}
				else if (gcMemory > 100)
				{
					gcCount100byte++;
				}
				else if (gcMemory > 10)
				{
					gcCount10byte++;
				}
			}
			freeMemory = System.freeMemory;
			
			str += "\n100MB\tGC発生回数？\t: " + gcCount100MB;
			str += "\n10MB\tGC発生回数？\t: " + gcCount10MB;
			str += "\n1MB\t\tGC発生回数？\t: " + gcCount1MB;
			str += "\n100KB\tGC発生回数？\t: " + gcCount100KB;
			str += "\n10KB\tGC発生回数？\t: " + gcCount10KB;
			str += "\n1KB\t\tGC発生回数？\t: " + gcCount1KB;
			str += "\n100byte\tGC発生回数？\t: " + gcCount100byte;
			str += "\n10byte\tGC発生回数？\t: " + gcCount10byte;
			str += "\n\t\t計GC発生回数？\t: " + gcCount;
			
			str += "\n\t\tGC発生率？\t\t: " + ((gcCount / (totalFrames++)) * 100) + "%";
			
			txt.text = str;
		}
		
		[Inline]
		final private function stringCastTest():void
		{
			var i:int = LOOP;
			while (i--)
			{
				String("00000" + i).substr( -5, 5);
			}
		}
		
		[Inline]
		final private function toStringCast():void
		{
			var i:int = LOOP;
			while (i--)
			{
				("00000" + i).toString().substr( -5, 5);
			}
		}
		
		[Inline]
		final private function asCast():void
		{
			var i:int = LOOP;
			while (i--)
			{
				(("00000" + i) as String).substr( -5, 5);
			}
		}
	}
}

import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.geom.Rectangle;
import flash.system.System;
import flash.utils.ByteArray;
import flash.utils.Dictionary;
import flash.utils.getTimer;
class Tester
{
	public var time:Number = 0;
	
	public var name:String;
	
	public var test:Function;
	
	public var count:Number = 1;
	
	public function start():String
	{
		const startTime:int = getTimer();
		test();
		time += getTimer() - startTime;
		return name + (time / (count++)) + " ms.\n";
	}
	
	public function get timeAverage():Number
	{
		return time / count;
	}
	
	public function Tester(name:String, test:Function)
	{
		this.name = name;
		this.test = test;
	}
}