/**
 * Copyright simultechnology ( http://wonderfl.net/user/simultechnology )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ixsv
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	public class PentagonalStar extends Sprite
	{
		private var _arrayStar:Array = [];
		private var _arrayRotation:Array = [];
		
		public function PentagonalStar()
		{
			this.addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
		}
		
		/* 
		* 初期処理メソッド
		*/
		private function init(e:Event):void
		{
			this.removeEventListener(Event.ADDED_TO_STAGE, init);
			// 文字列フォーマットの指定
			var tm:TextFormat = new TextFormat();
			tm.bold = true;
			tm.font = "Gothic";
			tm.size = 20;
			// 文字列の作成
			var tf:TextField = new TextField();
			tf.defaultTextFormat = tm;
			tf.width = 300;
			tf.text = "More Click\nanywhere!!";
			tf.x = stage.stageWidth/2;
			tf.y = stage.stageHeight/2;
			this.stage.addChild(tf);
			
			// 一つ目の星を作成
			var star:Sprite = new Sprite();
			createStar(200, 200, 50, star);
			this.stage.addEventListener(MouseEvent.CLICK, goToCreateStar, false, 0, true);
		}
		
		/*
		* 2つ目以降の星を作成するメソッド
		*/
		private function goToCreateStar(e:MouseEvent):void
		{
			var star:Sprite = new Sprite();
			createStar(mouseX, mouseY, 100 * (Math.random() * 0.5 + 0.5), star);
		}
		
		/*
		* 星を描写するメソッド
		*/
		private function createStar(x:int, y:int, radius:int, star:Sprite):void
		{	
			star.graphics.lineStyle(2, (Math.random() * 0.9 + 0.1) * 0xffffff, Math.random() * 0.5 + 0.5);
			star.x = x;
			star.y = y;
			star.graphics.moveTo(radius * Math.cos(72 * Math.PI / 180), radius * Math.sin(72 * Math.PI / 180));
			// 順番に角度72の倍数ずつ、順番に頂点をずらしていくと正五角形になるが、ここで欲しいのは
			// 星型なので、頂点を一つ飛ばしでラインを書いていく。なのでfor文のインクリメントは2の倍数
			for (var i:int = 0; i < 5; i += 2)
			{
				star.graphics.lineTo(radius * Math.cos((72 + 72 * i) * Math.PI / 180 ), radius * Math.sin((72 + 72 * i) * Math.PI / 180));
			}
			// 上記の理由によりfor文のインクリメントは奇数
			for (var i:int = 1; i < 6; i += 2)
			{
				star.graphics.lineTo(radius * Math.cos((72 + 72 * i) * Math.PI / 180 ), radius * Math.sin((72 + 72 * i) * Math.PI / 180));	
			}
			// 回転度数を設定（-5度 ～ 5度）
			this._arrayRotation.push(Math.random() >= 0.5 ? (Math.random() * 0.9 + 0.1) * 5 : (Math.random() * -0.9 - 0.1) * 5);
			// 作成した星を配列に追加
			this._arrayStar.push(star);
	
			addEventListener(Event.ENTER_FRAME, rotate, false, 0, true);		
			addChild(star);
		}
		
		private function rotate(e:Event):void
		{
			for (var i:int = 0; i < this._arrayStar.length; i++) {
				
				this._arrayStar[i].rotation += this._arrayRotation[i];
			}
		}
	}
}