/**
 * Copyright agenda23 ( http://wonderfl.net/user/agenda23 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ixXW
 */

package
{
    import flash.display.*;
    import flash.events.*;
	import flash.geom.*;
    import flash.filters.*;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.system.System;
	import flash.text.*;
	import flash.utils.*;
	import flash.ui.Keyboard;
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.effects.utils.*;
    import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.*;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.CompositeMaterial;
	
	import caurina.transitions.*;
	import net.hires.debug.Stats;
	//import org.flashdevelop.utils.FlashConnect;


    [SWF(frameRate=60,backgroundColor=0x000000) ]

    public class vertex_animation extends Sprite
    {
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var objSphere:Sphere;
		private var gx:Number = 16;
		private var gy:Number = 16;
		private var grad:Number = 80;
		private var isTween:Boolean = true;
		private var key_value:Boolean;
		private var val:Number = 7;
		private var tf:TextField;
		private var str:String = "";
		private var tmpSphere:Sphere;
		private var v:Vertex3D;

        public function vertex_animation()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.LOW;
            init3D();
			addChild(new Stats({ bg: 0x1A1A1A }));
			
			
			tf = new TextField();
			stage.addChild(tf);
			tf.x = 5;
			tf.y = 120;
			tf.width  = 100;
			tf.height = 20;
			tf.textColor = 0x08FF10;
			tf.multiline = true;
			tf.type = TextFieldType.DYNAMIC;
			tf.text = str;
			
			var timer:Timer = new Timer(1000);
			timer.addEventListener(TimerEvent.TIMER,timer_handler);
			timer.start();
			
			
			//頂点リセット用入力イベント(Rキー)
			function keyDownHandler2 (event:KeyboardEvent):void {
				
				 if (event.keyCode == 82) {
					    for each(var v:Vertex3D in objSphere.geometry.vertices) {
							v.x = v.extra.x0;
							v.y = v.extra.y0;
							v.z = v.extra.z0;
						}
						isTween = false;
				 }
			event.updateAfterEvent(); 
				}
			stage.addEventListener (KeyboardEvent.KEY_DOWN, keyDownHandler2);
			
			
        }
		//描画初期化
        private function init3D():void
        {
            viewport = new Viewport3D(0,0,true);
            viewport.opaqueBackground = 0x000000;
            addChild(viewport);
			

			
            renderer = new BasicRenderEngine();

            camera = new Camera3D();
            camera.z = -450;
            camera.focus = 500;
            camera.zoom = 1;

            scene = new Scene3D();

            var colorMat:ColorMaterial = new ColorMaterial( 0x000000, 1 );
            var wireMat:WireframeMaterial = new WireframeMaterial( 0x08FF10 );
            var compoMat:CompositeMaterial = new CompositeMaterial();
            compoMat.addMaterial(colorMat);
            compoMat.addMaterial(wireMat);
            compoMat.doubleSided = false;

            objSphere = new Sphere(compoMat, grad, gx, gy );
            scene.addChild(objSphere);
			
			
            addEventListener(Event.ENTER_FRAME, onEnterFrame); 
            renderer.renderScene(scene, camera, viewport);
			
				//頂点初期位置をVertex3Dのextraに格納
				for each(var v:Vertex3D in objSphere.geometry.vertices) {
				v.extra = {
				x0 : v.x,
				y0 : v.y,
				z0 : v.z
				}
			}
        }

        private function onEnterFrame(event:Event):void
        {
            objSphere.rotationY = stage.mouseX;
            objSphere.rotationX = stage.mouseY;
            objSphere.rotationZ += 1;
			  
            renderer.renderScene(scene, camera, viewport);
			
        }

		
		  private function timer_handler (e:Event):void{
		  var num:Number = 1;
		 if (isTween){
		  for each(var i:Vertex3D in objSphere.geometry.vertices) {
			if (num % val == 0) {
				Tweener.addTween(i, { x:i.x*2, 
									  y:i.y*2,
									  z:i.z*2,
									  time:Math.random(),
									  delay:0,
									  transition:"easeInOutElastic"
									});

			}
			num++;
		  }
		  isTween = false;
		 }else{
			for each(i in objSphere.geometry.vertices) {
			if (num % val == 0) {
				Tweener.addTween(i, { x:i.x*0.5, 
									  y:i.y*0.5,
									  z:i.z*0.5,
									  time:0.5,
									  delay:0,
									  transition:"easeInOutElastic"
									});

			}
			num++;
		  }
		 isTween = true;
		 }
			renderer.renderScene(scene,camera,viewport);
		}
	}
}
