/**
 * Copyright simbolosocultos ( http://wonderfl.net/user/simbolosocultos )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ixL3
 */

// forked from cpu_t's 爆発
// 出現するブロックをクリックして爆発させる
// 
// bombtterの発言を取得して表示させたかったけど、twitterAPIの使い方がわからなかった。
// http://twitter.com/bombtter
// 
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    public class FlashTest extends Sprite
    {
        public function FlashTest()
        {
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            Particle.init(stage);
            
            _count = 0;
            _blocks = new Array();
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private var _count:Number;
        private var _blocks:Array;
        
        private function loop(e:Event):void
        {
            Particle.update();
            if (++_count % 10 != 0 || _blocks.length >= 20) return;
            _count = 0;
            var index:uint = 0;
            while (_blocks[index] != null)
                index++;
            var block:Block = _blocks[index] = new Block();
            block.x = (Math.random() + .5) * stage.stageWidth * .5;
            block.y = (Math.random() + .5) * stage.stageHeight * .5;
            block.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void
            {
                block.bomb();
                _blocks.splice(_blocks.indexOf(block), 1);
            });
            addChild(block);
        }
    }
}
import flash.display.DisplayObjectContainer;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
class Block extends Sprite
{
    private var g:Graphics
    private var color:uint;
    public function Block()
    {
        g = this.graphics;
        color =
            Math.random() * 0xFF * 0x010000 +
            Math.random() * 0xFF * 0x000100 +
            Math.random() * 0xFF * 0x000001;
        g.beginFill(color);
        if (Math.random() < .5)
            g.drawCircle(0, 0, 30);
        else
            g.drawRect(-25, -25, 50, 50);
        g.endFill();
    }
    public function bomb():void
    {
        Particle.bombEffect(this.x, this.y, color);
        this.parent.removeChild(this);
    }
}
class Particle
{
    static private var pList:Vector.<Part>;
    static private var sp:Sprite;
    static public function init(stage:DisplayObjectContainer):void
    {
        pList = new Vector.<Part>();
        stage.addChild(sp = new Sprite());
    }
    static public function update():void
    {
        var index:uint = 0;
        while (index < pList.length)
        {
            pList[index].update();
            if (pList[index].life < 0)
            {
                sp.removeChild(pList[index]);
                pList.splice(index, 1);
                continue;
            }
            index++;
        }
    }
    static public function bombEffect(x:Number, y:Number, color:uint):void
    {
        for (var i:int = 0; i < 50; i++)
        {
            var p:Part = new Part(20, (Math.random()-.5) * 10, (Math.random()-.5) * 10);
            p.x = x;
            p.y = y;
            p.graphics.beginFill(color);
            p.graphics.drawCircle(0, 0, 3);
            pList.push(p);
            sp.addChild(p);
        }
    }
}
class Part extends Shape
{
    public var life:Number = 0;
    public var vx:Number;
    public var vy:Number;
    public function Part(life:Number = 0, vx:Number = 0, vy:Number = 0)
    {
        this.life = life;
        this.vx = vx;
        this.vy = vy;
        super();
    }
    public function update():void
    {
        this.x += vx;
        this.y += vy;
        life--;
    }
}
