/**
 * Copyright h1ro ( http://wonderfl.net/user/h1ro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ix4n
 */

//----------------------------------------
// 3D座標のランダム配置テスト
// いい感じのランダムを作りたい!と思って研究中
// なんだか偏りがとれず、まだまだ試作段階です
// 全ての座標を保持して範囲内か判断するのは重いのかなぁと思い
// 0,0,0を初期値としてスタート
// 今と次の座標との距離のみを測って生成しています
// @author h1ro
//----------------------------------------
package {
    
    import flash.events.Event;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.view.BasicView;
    
    public class RandomPlace extends BasicView {
        
        private var container:DisplayObject3D;
        //どれくらいまで座標が離れていて欲しいかをmaxに
        private var maxPos:Number = 1000;
        //自分の周りでいて欲しくない範囲をminに
        private var minPos:Number = 500;
        
        //1000個ランダムで生成
        private var randMax:int = 1000;
        //初期値として0,0,0を起点として生成してみる
        private var currentX:Number = 0;
        private var currentY:Number = 0;
        private var currentZ:Number = 0;
        //座標生成が成功したかどうかのフラグ
        private var successFlg:Boolean;
        
        public function RandomPlace() {
            
            //全部を格納しとくcontainerを作る
            container = new DisplayObject3D();
            scene.addChild(container);
            
            //99回ランダム生成しても当てはまる数値が出なかった場合の初期値
			var pos:Number = 0;
			var distance:Number;
			var rangePos:Number = maxPos - minPos;
			var vector:Number;
			
			//ランダムで生成するときにいい感じに重ならず生成できるかテスト
            for (var i:int=0; i<randMax; i++){
                
                //生成が成功したか判断するフラグを初期化
                successFlg = false;
                //カラーもランダムでセット
                var material:ColorMaterial = new ColorMaterial(Math.random() * 0xff0000);
                //両面を使う
                material.doubleSided = true;
                //Planeを生成
                var plane:Plane = new Plane(material, 10, 10);
                
                //ランダムで座標を生成
                for(var n:int=0;n<99;n++){
                    //次のx座標候補
                    if (Math.round(Math.random() * 2) <= 1) {vector = 1;}else {vector = -1;}
                    var nextX:Number = vector * (Math.floor(Math.random() * rangePos + minPos));
                    if (Math.round(Math.random() * 2) <= 1) {vector = 1;}else {vector = -1;}
                    var nextY:Number = vector * (Math.floor(Math.random() * rangePos + minPos));
                    if (Math.round(Math.random() * 2) <= 1) {vector = 1;}else {vector = -1;}
                    var nextZ:Number = vector * (Math.floor(Math.random() * rangePos + minPos));
                    //距離を計算
                    var tmpNextX:Number = Math.pow(currentX - nextX , 2);
                    var tmpNextY:Number = Math.pow(currentY - nextY , 2);
                    var tmpNextZ:Number = Math.pow(currentZ - nextZ , 2);
                    distance = Math.sqrt(tmpNextX + tmpNextY + tmpNextZ);
                    
		    	    //minPos以上はなれる座標が出るまで再計算し続ける
    				if (minPos >= distance) {
			    	}else {
                       //次の基準座標にする
                       currentX = nextX;
                       currentY = nextY;
                       currentZ = nextZ;
                       successFlg = true;
			    	    break;
			    	}
                }
                
          	     //99回もやって全て同じ場合は最低限離した座標をセット
          	     if (successFlg){
                    //座標をセット
                     plane.x = currentX;
                     plane.y = currentY;
                     plane.z = currentZ;
                 }else{
                     plane.x = currentX + minPos;
                     plane.y = currentY + minPos;
                     plane.z = currentZ + minPos;
                 }
                
                //シーンに追加
                container.addChild(plane);
                
            }
            
            //イベント追加
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                //奥行き具合も確認したいのでくるくる回す
                container.yaw(3);
                }
            );
            //レンダリングスタート
            startRendering();
        }
    }
}