/**
 * Copyright mathatelle ( http://wonderfl.net/user/mathatelle )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iwoR
 */

// ぽとぽと落ちる
package {
import Box2D.Dynamics.*;
import Box2D.Collision.*;
import Box2D.Collision.Shapes.*;
import Box2D.Common.Math.*;
import flash.events.Event;
import flash.display.Sprite;

[SWF(backgroundColor="#000000", width="465", height="465")]

public class Box2dLesson extends Sprite {
    private var m_world:b2World;
    private var m_iterations:int;
    private var m_timeStep:Number;
    private var m_physScale:Number;

    public function Box2dLesson() {
        stage.scaleMode = "noScale";
        stage.align = "TL";
        init();
        this.addEventListener(Event.ENTER_FRAME, Update, false, 0, true);
        setDebug();
    }
    
    //--------------------------------------------------------
    // update every frame
    //--------------------------------------------------------
    private var count:int = 0;
    private function Update(e:Event):void {
        m_world.Step(m_timeStep, m_iterations);
        if (count == 0){
            addBall();
        }
        count = (count + 1) % 15;
        //DestroyBody
        for (var b:b2Body = m_world.GetBodyList(); b; b = b.GetNext()) {
            if (b.GetWorldCenter().y * m_physScale > 600){
                m_world.DestroyBody(b);
            }
        }
    }
    
    //--------------------------------------------------------
    // init
    //--------------------------------------------------------
    private function init():void {
        //
        {
        m_iterations = 10;
        m_timeStep = 1/30;
        m_physScale = 30; // =1m (1meter=30pixels)
        }
        // make base world
        {
        var worldAABB:b2AABB = new b2AABB();
        worldAABB.lowerBound.Set(-1000.0, -1000.0);
        worldAABB.upperBound.Set(1000.0, 1000.0);
        var gravity:b2Vec2 = new b2Vec2(0.0, 10.0);
        var doSleep:Boolean = true;
        m_world = new b2World(worldAABB, gravity, doSleep);
        }
        // floor
        {
        var floorWidth:Number=465;
        var floorHeight:Number=30;
        var floorDef:b2PolygonDef = new b2PolygonDef();
        floorDef.SetAsBox(floorWidth/2/m_physScale,floorHeight/2/m_physScale);
        floorDef.density = 100.0;
        floorDef.friction = 1.0/m_physScale;

        var floorBD:b2BodyDef = new b2BodyDef();
        floorBD.position.Set(stage.stageWidth/2/m_physScale, (stage.stageHeight-floorHeight/2)/m_physScale);
        floorBD.angle = Math.PI;

        var floor:b2Body = m_world.CreateBody(floorBD);
        floor.CreateShape(floorDef);
        };
            
    }

    //--------------------------------------------------------
    // create object
    //--------------------------------------------------------    
    // add Ball
    private function addBall():void {
        var floorWidth:Number = 465;
        var CircleRadius:Number = 10+Math.random()*90;
        var circleDef:b2CircleDef = new b2CircleDef();
        circleDef.radius = CircleRadius/m_physScale;
        circleDef.density = 30.0/m_physScale;
        circleDef.friction = 15.0/m_physScale;
        circleDef.restitution = 15.0/m_physScale;
        var circleBD:b2BodyDef = new b2BodyDef();
        circleBD.position.Set(
            floorWidth/2/m_physScale+Math.cos(Math.random()*Math.PI)*Math.random()*floorWidth/2/m_physScale,
            CircleRadius/2/m_physScale);
        circleBD.angle = Math.PI*2*Math.random();
        var circle:b2Body = m_world.CreateBody(circleBD);
        circle.CreateShape(circleDef);
        circle.SetMassFromShapes();
    }

    
    //--------------------------------------------------------
    // debug mode
    //--------------------------------------------------------
    private function setDebug():void {
        var debugDraw:b2DebugDraw = new b2DebugDraw();
        debugDraw.m_sprite = this;
        debugDraw.m_drawScale = m_physScale;
        debugDraw.m_fillAlpha = .8;
        debugDraw.m_lineThickness = 1;
        debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
        m_world.SetDebugDraw(debugDraw);
    }
}
}