/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iwlg
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
	
    public class FlashTest extends Sprite {
		private var _rad:Number;
		private var _star:Star;
		
        public function FlashTest() {
			_rad = 0;
			
            this.graphics.beginFill(0x000040);
            this.graphics.drawRect(0, 0, 465, 465);
            this.graphics.endFill();
            
            this.addEventListener(Event.ENTER_FRAME, proc)
			
			_star = new Star();
			this.addChild(_star);
        }

        private function proc(e:Event):void {
			_rad -= 0.05;
			if (_rad < 0) {
				_rad += Math.PI * 2;
			}
			
			_star.x = 232.5 + (Math.cos(_rad) * 120);
			_star.y = 232.5 + (Math.sin(_rad) * 120);
			_star.rotationZ -= 4;
			
			if (_star.rotationZ < 0) {
				_star.rotationZ += 360;
			}
			
			var s:StarSmall = new StarSmall(
				_star.x + (Math.random() * 20 - 10),
				_star.y + (Math.random() * 20 - 10),
				_rad + (Math.PI * 0.5) + (Math.random() * 1.0));
			this.addChild(s);
		}
    }
}

import caurina.transitions.Tweener;
import flash.display.Graphics;
import flash.display.Sprite;

class Star extends Sprite {
	public function Star() {
		Drawer.DrawStar(this.graphics, 40);
	}
}

class StarSmall extends Sprite {
	public function StarSmall(px:Number, py:Number, rad:Number) {
		this.x = px;
		this.y = py;
		Drawer.DrawStar(this.graphics, 2.5 + (Math.random() * 5));

		Tweener.addTween(this,
		{
			x:px + (Math.cos(rad) * 80)
			, y:py + (Math.sin(rad) * 80)
			, time:30
			, transition:"linear"
			, useFrames:true
		}
		);
		Tweener.addTween(this,
		{
			alpha:0
			, delay:20
			, time:10
			, useFrames:true
			, onComplete:onEnd
		}
		);
	}
	
	private function onEnd():void {
		this.parent.removeChild(this);
	}
}

class Drawer {
	static public function DrawStar(g:Graphics, size:Number):void {
        g.beginFill(0xffff40);
        var lengthMin:Number = size * 0.55;
        var lengthMid:Number = size * 0.85;
        var lengthMax:Number = size * 1.0;
        var rad:Number = ( -Math.PI * 0.5) + (Math.PI * 0.2);
        g.moveTo(Math.cos(rad) * lengthMin, Math.sin(rad) * lengthMin);
        for (var index:uint = 0; index < 5; ++index) {
            rad += Math.PI * 0.16;
            g.lineTo(Math.cos(rad) * lengthMid, Math.sin(rad) * lengthMid);
            rad += Math.PI * 0.04;
            var ctrlX:Number = Math.cos(rad) * lengthMax;
            var ctrlY:Number = Math.sin(rad) * lengthMax;
            rad += Math.PI * 0.04;
            g.curveTo(ctrlX, ctrlY, Math.cos(rad) * lengthMid, Math.sin(rad) * lengthMid);
            rad += Math.PI * 0.16;
            g.lineTo(Math.cos(rad) * lengthMin, Math.sin(rad) * lengthMin);
        }
        g.endFill();
	}
}