/**
 * Copyright mex_md ( http://wonderfl.net/user/mex_md )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iwfK
 */

// forked from mex's 【AS100本ノック】14回目：バルーン
/**
 * AS100本ノック
 * 14回目のお題は「バルーン」
 * あなたなりの「バルーン」を表現してください。
 **/
//すいません↓のほぼそのまま使っただけです。。。
// forked from paq's [QuickBox2D] Soft body

package 
{    
    
    import com.actionsnippet.qbox.QuickBox2D;
    import com.actionsnippet.qbox.QuickObject;
    import flash.display.MovieClip;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
 
    [SWF(width = "465", height = "465", frameRate = "30")]
    
    public class FlashTest extends MovieClip
    {
        public var baloons:Array = [];
        public var radius:Number = 0.2;
        public var circleNum:int = 20;
        public var nColor:int = 0xff0000;
        private var sim:QuickBox2D;
        
        private var centerRadius:Number = 0.5;
        
        public function FlashTest() 
        {
            stage.quality = StageQuality.LOW;
            
            sim = new QuickBox2D(this, { debug:false, gravityX:0, gravityY:-2 });
            sim.createStageWalls();
          
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler)
            sim.start();
            sim.mouseDrag();
            
            addEventListener(Event.ENTER_FRAME, xFake);                       
        }
        
        private function mouseDownHandler(e:MouseEvent):void 
        {
            
            if (!(e.target is Sprite))
            {
                centerRadius = 0.5;
                stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler)
                addEventListener(Event.ENTER_FRAME, inflateBaloon);
            }
        }
        
        private function inflateBaloon(e:Event):void 
        {
            centerRadius += 0.01;
        }
        
        private function mouseUpHandler(e:MouseEvent):void 
        {
            removeEventListener(Event.ENTER_FRAME, inflateBaloon);
            stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpHandler)
            makeBaloon(new Point(e.localX/30, e.localY/30));
        }
       
        private function xFake(e:Event):void 
        {
            graphics.clear();
            graphics.lineStyle(1,nColor);
            graphics.beginFill(nColor);
            var sPos:Point = new Point();
            for (var j:int = 0; j < baloons.length; j++ )
            {
                for (var i:int = 0; i < circleNum; i++) {
                    var circle:QuickObject = baloons[j][i];
                    if (i == 0) 
                    {
                        sPos = new Point(circle.x*30, circle.y*30);
                        graphics.moveTo(sPos.x, sPos.y);
                    } else
                    {
                        graphics.lineTo(circle.x*30,circle.y*30);
                    }
                }
                graphics.lineTo(sPos.x, sPos.y);
            }
            graphics.endFill();
        } 
        
        private function makeBaloon(center:Point):void
        {
            var circles:Array = [];
            baloons.push(circles);
            var nRadius:Number = 1;
            var centerCircle:QuickObject = sim.addCircle( { x:center.x, y:center.y, radius:centerRadius, restitution:0.2, lineAlpha:0, fillColor:0x009900, fillAlpha:0 } );
            
            for (var i:int = 0; i < circleNum; i++) {
                var nR:Number = Math.PI*2/circleNum*i;
                var circle:QuickObject = sim.addCircle({x:center.x+(centerRadius+nRadius)*Math.cos(nR), y:center.y+(centerRadius+nRadius)*Math.sin(nR), radius:radius, lineAlpha:0, fillAlpha:0});
                circles.push(circle);
                sim.addJoint({a:centerCircle.body, b:circle.body, frequencyHz:10, dampingRatio:0.1, collideConnected:false});
                if (i > 0) {
                    sim.addJoint({a:circles[i-1].body, b:circle.body, frequencyHz:0, dampingRatio:0.1, restitution:0});
                }
            }
            sim.addJoint({a:circles[circleNum-1].body, b:circles[0].body, length:radius*2, frequencyHz:0});
        }
    }
}

