/**
 * Copyright WinField95 ( http://wonderfl.net/user/WinField95 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ivjt
 */

// forked from civet's Flixel Primer (for v2.55)
/**
 * Flixel Primer
 * Copyright (c) 2010 Andreas Zecher, http://www.pixelate.de
 * original source(for Flixel v2.32): https://github.com/pixelate/flixel_primer
 */
 package {    
    import org.flixel.*;
    
    [SWF(width="640", height="480", backgroundColor="#ABCC7D")]
    
    public class Main extends FlxGame
    {
        public function Main():void
        {
            super(640, 480, PlayState, 1);
        }
    }
}

import org.flixel.*;

class PlayState extends FlxState
{        
    private var SoundExplosionShip:Class;
    private var SoundExplosionAlien:Class;
    private var SoundBullet:Class;

    private var _ship: Ship;
    private var _aliens: FlxGroup;
    private var _bullets: FlxGroup;        
    private var _scoreText: FlxText;
    private var _gameOverText: FlxText;
    private var _spawnTimer: Number;
    private var _spawnInterval: Number = 2.5;
    
    override public function create():void
    {
        FlxG.score = 0;
        
        FlxG.bgColor = 0xFFABCC7D;
        
        _ship = new Ship();            
        add(_ship);
        
        _aliens = new FlxGroup();
        add(_aliens);
        
        _bullets = new FlxGroup();
        add(_bullets);

        _scoreText = new FlxText(10, 8, 200, "0");
        _scoreText.setFormat(null, 32, 0xFF597137, "left");
        add(_scoreText);
        
        resetSpawnTimer();
                    
        super.create();
    }

    override public function update():void
    {            
        FlxG.collide(_aliens, _bullets, overlapAlienBullet);
        FlxG.collide(_aliens, _ship, overlapAlienShip);
        
        if(FlxG.keys.justPressed("SPACE") && _ship.alive)
        {
            spawnBullet(_ship.getBulletSpawnPosition());                    
        }

        if(FlxG.keys.ENTER && !_ship.alive)
        {                
            FlxG.switchState(new PlayState());
        }
        
        _spawnTimer -= FlxG.elapsed;
        
        if(_spawnTimer < 0)
        {
            spawnAlien();
            resetSpawnTimer();
        }
                    
        super.update();
    }
    
    private function spawnAlien():void
    {
        var x: Number = FlxG.width;
        var y: Number = Math.random() * (FlxG.height - 100) + 50;
        _aliens.add(new Alien(x, y));
    }    
    
    private function spawnBullet(p: FlxPoint):void
    {
        var bullet: Bullet = new Bullet(p.x, p.y);
        _bullets.add(bullet);
        FlxG.play(SoundBullet);
    }    
    
    private function resetSpawnTimer():void
    {
        _spawnTimer = _spawnInterval;            
        _spawnInterval *= 0.95;
        if(_spawnInterval < 0.1)
        {
            _spawnInterval = 0.1;
        }
    }
    
    private function overlapAlienBullet(alien: Alien, bullet: Bullet):void
    {
        var emitter:FlxEmitter = createEmitter();
        emitter.at(alien);        
        alien.kill();
        bullet.kill();    
        FlxG.play(SoundExplosionAlien);    
        FlxG.score += 1;
        _scoreText.text = FlxG.score.toString();                    
    }
    
    private function overlapAlienShip(alien: Alien, ship: Ship):void
    {
        var emitter:FlxEmitter = createEmitter();
        emitter.at(ship);            
        ship.kill();
        alien.kill();
        FlxG.shake(0.02);
        FlxG.play(SoundExplosionShip);    
        
        _gameOverText = new FlxText(0, FlxG.height / 2, FlxG.width, "GAME OVER\nPRESS ENTER TO PLAY AGAIN");                    
        _gameOverText.setFormat(null, 16, 0xFF597137, "center");
        add(_gameOverText);
    }
            
    private function createEmitter():FlxEmitter
    {
        var emitter:FlxEmitter = new FlxEmitter();
        //emitter.delay = 1;
        emitter.gravity = 0;
        emitter.maxRotation = 0;
        emitter.setXSpeed(-500, 500);
        emitter.setYSpeed(-500, 500);
        
        
        var particles: int = 10;
        for(var i: int = 0; i < particles; i++)
        {
            var particle:FlxParticle = new FlxParticle();
            particle.makeGraphic(2, 2, 0xFF597137);
            particle.exists = false;
            emitter.add(particle);
        }
        emitter.start();
        add(emitter);
        return emitter;        
    }
}

import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.net.URLRequest;
import flash.system.LoaderContext;

class Alien extends FlxSprite
{    
    public function Alien(x: Number, y: Number):void
    {
        super(x, y, null);
        velocity.x = -200;
        
        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
        loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/3/32/32c3/32c3229c715c4e15e3541fd1e587dff9a13dacb7"), new LoaderContext(true));
    }    

    override public function update():void
    {            
        velocity.y = Math.cos(x / 50) * 50;
        super.update();            
    }
    
    private function onLoadComplete(e:Event):void
    {
        e.currentTarget.removeEventListener(Event.COMPLETE, onLoadComplete);
        this.pixels = e.currentTarget.content.bitmapData;
    }
}

class Ship extends FlxSprite
{        
    public function Ship():void
    {
        super(50, 50, null);
        
        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
        loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/9/92/929d/929d78524407f32a5687e3a4aa8fd2c6a91ba433"), new LoaderContext(true));
    }

    override public function update():void
    {
        velocity.x = 0;
        velocity.y = 0;

        if(FlxG.keys.LEFT)
        {
            velocity.x = -250;
        }
        else if(FlxG.keys.RIGHT)
        {
            velocity.x = 250;                
        }

        if(FlxG.keys.UP)
        {
            velocity.y = -250;                
        }
        else if(FlxG.keys.DOWN)
        {
            velocity.y = 250;
        }
        
        super.update();
        
        if(x > FlxG.width-width-16)
        {
            x = FlxG.width-width-16;
        }
        else if(x < 16)
        {
            x = 16;                
        }

        if(y > FlxG.height-height-16)
        {
            y = FlxG.height-height-16;
        }
        else if(y < 16)
        {
            y = 16;                
        }    
    }
    
    public function getBulletSpawnPosition():FlxPoint
    {
        var p: FlxPoint = new FlxPoint(x + 36, y + 12);
        return p;
    }        
    
    private function onLoadComplete(e:Event):void
    {
        e.currentTarget.removeEventListener(Event.COMPLETE, onLoadComplete);
        this.pixels = e.currentTarget.content.bitmapData;
    }
}

class Bullet extends FlxSprite
{        
    public function Bullet(x: Number, y: Number):void
    {            
        super(x, y);
        makeGraphic(16, 4, 0xFF597137);
        velocity.x = 1000;
    }
}