/**
 * Copyright ysle ( http://wonderfl.net/user/ysle )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ivbs
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;

	public class Temp extends Sprite
	{
		private var dots:Vector.<Point> = new Vector.<Point>()
		private var distance:Number
		private var maxDistance:Number = 100
		private var transparency:Number
		private var lup:Object 
		
		private var first:Dot
		private var second:Dot
		private var matrix:Matrix = new Matrix()
		
		private var bmd:BitmapData
		private var screen:Sprite = new Sprite()
		private var point:Point = new Point()		
		private var blur:BlurFilter = new BlurFilter(15,15,3)

		public function Temp() 
		{	
			addChild(new Bitmap(bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0)))			
			
			for (var c:Number = 0; c < 30; c++ ) dots.push( new Dot(Math.random() * bmd.width, Math.random() * bmd.height, Math.random() * 10 -5, Math.random() * 10 -5, randomColor(), c))

			
			
			stage.quality = 'medium'
			stage.addEventListener('enterFrame', onEnterFrame)
		}
		
		private function onEnterFrame(...e):void 
		{
			screen.graphics.clear()
			lup = { }

			for each (var d1:Dot in dots)
			{
				if ((d1.x += d1.sx) < 0 || d1.x > bmd.width) d1.x += d1.sx *= -1
				if ((d1.y += d1.sy) < 0 || d1.y > bmd.height) d1.y += d1.sy *= -1
				screen.graphics.beginFill(d1.c)
				screen.graphics.drawCircle(d1.x,d1.y,4)
			}

			for each (d1 in dots)
			{
				for each (var d2:Dot in dots)
				{
					if (d1 != d2 && !lup[d2.id + '_' + d1.id] && (distance = Point.distance(d1, d2))  < maxDistance)
					{
						lup[d1.id + '_' + d2.id] = 1
						
						if (d1.x > d2.x) { first = d1; second = d2 }
						else { first = d2; second = d1 }
						
						matrix.createGradientBox(second.x - first.x, second.y - first.y, 0, first.x, first.y)
						
						transparency = 1 - distance / maxDistance
						screen.graphics.lineStyle(0)
						screen.graphics.lineGradientStyle('linear', [first.c, second.c], [transparency,transparency], [0, 0xff], matrix)
						screen.graphics.moveTo(first.x, first.y)
						screen.graphics.lineTo(second.x, second.y)
						screen.graphics.endFill()
					}
				}
			}
			
			bmd.lock()
			bmd.applyFilter(bmd, bmd.rect, point, blur)
			bmd.draw(screen)
			bmd.unlock()
		}
		
		private function randomColor():Number
		{
			var tone:Number = int(Math.random() * 3)
			var c:int = 3
			var color:Number = 0xff<< tone*8
			while (c--) if (tone != c) color += 0xff * Math.random() << c * 8
			return color
		}
	}
}

import flash.geom.Point
dynamic class Dot extends Point
{
	public function Dot(x:Number, y:Number, sx:Number, sy:Number, c:Number, id:Number):void
	{
		super(x, y)
		this.sx = sx
		this.sy = sy
		this.c = c
		this.id = c
	}
}
