/**
 * Copyright wetcradle ( http://wonderfl.net/user/wetcradle )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ivZk
 */

/**
UIComponent のためのスキンをコードで書いているので、いくつかアップしてみます。
*/
package {
    
    import flash.display.DisplayObject;
    import flash.display.Sprite;
        
    [SWF(backgroundColor=0x666666)]
    
    public class SkinSample extends Sprite {
        
        public function SkinSample():void {
            super();
            
            var ironButton:DummyComponent = new DummyComponent(IronButtonUpSkin, IronButtonUpSkin, IronButtonDownSkin);
            ironButton.setSize(100, 22);
            ironButton.move(10, 10);
            addChild(ironButton);
            
            var searchTextInput:DummyComponent = new DummyComponent(SearchTextInputUpSkin, SearchTextInputUpSkin, SearchTextInputFocusRectSkin);
            searchTextInput.setSize(60, 22);
            searchTextInput.move(30, 40);
            addChild(searchTextInput);
            
            var ironCheckBox:DummyComponent = new DummyComponent(IronCheckBoxUpIcon, IronCheckBoxSelectedUpIcon, IronCheckBoxSelectedDownIcon);
            ironCheckBox.setSize(14, 15);
            ironCheckBox.move(10, 70);
            addChild(ironCheckBox);
            
            var ironScrollUpArrow:DummyComponent = new DummyComponent(IronScrollUpArrowUpSkin, IronScrollUpArrowUpSkin, IronScrollUpArrowDownSkin);
            ironScrollUpArrow.setSize(15, 14);
            ironScrollUpArrow.move(200, 10);
            addChild(ironScrollUpArrow);
            
            var ironScrollTrack:DummyComponent = new DummyComponent(IronScrollTrackSkin);
            ironScrollTrack.setSize(15, 100);
            ironScrollTrack.move(200, ironScrollUpArrow.y + ironScrollUpArrow.height);
            addChild(ironScrollTrack);
            
            var ironScrollDownArrow:DummyComponent = new DummyComponent(IronScrollDownArrowUpSkin, IronScrollDownArrowUpSkin, IronScrollDownArrowDownSkin);
            ironScrollDownArrow.setSize(15, 14);
            ironScrollDownArrow.move(200, ironScrollTrack.y + ironScrollTrack.height);
            addChild(ironScrollDownArrow);
            
            var ironScrollThumb:DummyComponent = new DummyComponent(IronScrollThumbUpSkin);
            ironScrollThumb.setSize(15, 30);
            ironScrollThumb.move(200, ironScrollTrack.y + 20);
            addChild(ironScrollThumb);
        }
        
    }
}

import flash.display.DisplayObject;
import flash.events.MouseEvent;
class DummyComponent extends Sprite {
    
    private var _width:Number = 100;
    private var _height:Number = 100;
    
    private var skin:DisplayObject;
    
    private var upSkinClass:Class;
    private var overSkinClass:Class;
    private var downSkinClass:Class;
    
    public function DummyComponent(upSkinClass:Class, overSkinClass:Class=null, downSkinClass:Class=null):void {
        super();
        
        this.upSkinClass = upSkinClass;
        this.overSkinClass = overSkinClass ? overSkinClass : this.upSkinClass;
        this.downSkinClass = downSkinClass ? downSkinClass : this.overSkinClass;
        
        setSkin(upSkinClass);
        
        addEventListener(MouseEvent.ROLL_OVER, mouseEventHandler);
        addEventListener(MouseEvent.ROLL_OUT, mouseEventHandler);
        addEventListener(MouseEvent.MOUSE_DOWN, mouseEventHandler);
        addEventListener(MouseEvent.MOUSE_UP, mouseEventHandler);
    }
    
    override public function get width():Number {
        return _width;
    }
    override public function set width(value:Number):void {
        setSize(value, _height);
    }
    
    override public function get height():Number {
        return _height;
    }
    override public function set height(value:Number):void {
        setSize(_width, value);
    }
    
    public function setSize(width:Number, height:Number):void {
        if (width == _width && height == _height) {
            return;
        }
        _width = width;
        _height = height;
        drawSize();
    }
    
    public function move(x:Number, y:Number):void {
        this.x = x;
        this.y = y;
    }
    
    private function drawSize():void {
        if (skin) {
            skin.width = width;
            skin.height = height;
        }
    }
    
    private function setSkin(skinClass:Class):void {
        if (skin) {
            removeChild(skin);
        }
        skin = DisplayObject(new skinClass());
        addChild(skin);
        drawSize();
    }
    
    private function mouseEventHandler(e:MouseEvent):void {
        switch (e.type) {
        case MouseEvent.ROLL_OVER:
        case MouseEvent.MOUSE_UP:
            setSkin(overSkinClass);
            break;
        case MouseEvent.ROLL_OUT:
            setSkin(upSkinClass);
            break;
        case MouseEvent.MOUSE_DOWN:
            setSkin(downSkinClass);
            break;
        }
    }
    
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.geom.Rectangle;
class IronButtonUpSkin extends Sprite {
    
    private var bottomLightCanvas:Sprite;
    private var border:Sprite;
    private var fill:Sprite;
    
    private static const BORDER_THICKNESS:Number = 1;
    private static const RADIUS:Number = 3;
    
    public function IronButtonUpSkin():void {
        var colors:Array;
        var alphas:Array;
        var ratios:Array;
        var matrix:Matrix;
        
        bottomLightCanvas = new Sprite();
        bottomLightCanvas.graphics.beginFill(0, 1);
        bottomLightCanvas.graphics.drawRoundRect(0, 0, 100, 100, RADIUS * 2);
        bottomLightCanvas.graphics.endFill();
        bottomLightCanvas.scale9Grid = new Rectangle(RADIUS, RADIUS, 100 - RADIUS * 2, 100 - RADIUS * 2);
        addChild(bottomLightCanvas);
        
        var bottomLight:DropShadowFilter = new DropShadowFilter();
        bottomLight.blurX = 0;
        bottomLight.blurY = 1;
        bottomLight.distance = 1;
        bottomLight.inner = true;
        bottomLight.angle = -90;
        bottomLight.strength = 0.4;
        bottomLight.knockout = true;
        bottomLight.color = 0xffffff;
        bottomLightCanvas.filters = [bottomLight];
        
        border = new Sprite();
        border.graphics.beginFill(0x000000, 0.5);
        border.graphics.drawRoundRect(0, 0, 100, 100, RADIUS * 2);
        border.graphics.endFill();
        border.scale9Grid = new Rectangle(RADIUS, RADIUS, 100 - RADIUS * 2, 100 - RADIUS * 2);
        addChild(border);
        
        colors = [0xeeeeee, 0xaaaaaa];
        alphas = [1, 1];
        ratios = [0x00, 0xff];
        matrix = new Matrix();
        matrix.createGradientBox(100, 100, Math.PI / 2, 0, 0);
        fill = new Sprite();
        fill.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        fill.graphics.drawRoundRect(0, 0, 100, 100, (RADIUS - BORDER_THICKNESS) * 2);
        fill.graphics.endFill();
        fill.x = fill.y = BORDER_THICKNESS;
        fill.scale9Grid = new Rectangle(RADIUS - BORDER_THICKNESS, RADIUS - BORDER_THICKNESS, 100 - (RADIUS - BORDER_THICKNESS) * 2, 100 - (RADIUS - BORDER_THICKNESS) * 2);
        addChild(fill);
        
        var fillLight:DropShadowFilter = new DropShadowFilter();
        fillLight.blurX = 0;
        fillLight.blurY = 1;
        fillLight.distance = 1;
        fillLight.inner = true;
        fillLight.angle = 90;
        fillLight.strength = 0.5;
        fillLight.color = 0xffffff;
        fill.filters = [fillLight];
        
        width = height = 100;
    }
    
    override public function set width(value:Number):void {
        bottomLightCanvas.width = value;
        border.width = value;
        fill.width = value - BORDER_THICKNESS * 2;
    }
    
    override public function set height(value:Number):void {
        bottomLightCanvas.height = value;
        border.height = value - 1;
        fill.height = value - BORDER_THICKNESS * 2 - 1;
    }
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.geom.Rectangle;
class IronButtonDownSkin extends Sprite {
    
    private var bottomLightCanvas:Sprite;
    private var border:Sprite;
    private var fill:Sprite;
    
    private static const BORDER_THICKNESS:Number = 1;
    private static const RADIUS:Number = 3;
    
    public function IronButtonDownSkin():void {
        var colors:Array;
        var alphas:Array;
        var ratios:Array;
        var matrix:Matrix;
        
        bottomLightCanvas = new Sprite();
        bottomLightCanvas.graphics.beginFill(0, 1);
        bottomLightCanvas.graphics.drawRoundRect(0, 0, 100, 100, RADIUS * 2);
        bottomLightCanvas.graphics.endFill();
        bottomLightCanvas.scale9Grid = new Rectangle(RADIUS, RADIUS, 100 - RADIUS * 2, 100 - RADIUS * 2);
        addChild(bottomLightCanvas);
        
        var bottomLight:DropShadowFilter = new DropShadowFilter();
        bottomLight.blurX = 0;
        bottomLight.blurY = 1;
        bottomLight.distance = 1;
        bottomLight.inner = true;
        bottomLight.angle = -90;
        bottomLight.strength = 0.4;
        bottomLight.knockout = true;
        bottomLight.color = 0xffffff;
        bottomLightCanvas.filters = [bottomLight];
        
        border = new Sprite();
        border.graphics.beginFill(0x000000, 0.5);
        border.graphics.drawRoundRect(0, 0, 100, 100, RADIUS * 2);
        border.graphics.endFill();
        border.scale9Grid = new Rectangle(RADIUS, RADIUS, 100 - RADIUS * 2, 100 - RADIUS * 2);
        addChild(border);
        
        colors = [0xdddddd, 0x999999];
        alphas = [1, 1];
        ratios = [0x00, 0xff];
        matrix = new Matrix();
        matrix.createGradientBox(100, 100, Math.PI / 2, 0, 0);
        fill = new Sprite();
        fill.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        fill.graphics.drawRoundRect(0, 0, 100, 100, (RADIUS - BORDER_THICKNESS) * 2);
        fill.graphics.endFill();
        fill.x = fill.y = BORDER_THICKNESS;
        fill.scale9Grid = new Rectangle(RADIUS - BORDER_THICKNESS, RADIUS - BORDER_THICKNESS, 100 - (RADIUS - BORDER_THICKNESS) * 2, 100 - (RADIUS - BORDER_THICKNESS) * 2);
        addChild(fill);
        
        var fillShadow:DropShadowFilter = new DropShadowFilter();
        fillShadow.blurX = 10;
        fillShadow.blurY = 10;
        fillShadow.distance = 1;
        fillShadow.inner = true;
        fillShadow.angle = 90;
        fillShadow.strength = 0.3;
        fillShadow.color = 0x000000;
        fill.filters = [fillShadow];
        
        width = height = 100;
    }
    
    override public function set width(value:Number):void {
        bottomLightCanvas.width = value;
        border.width = value;
        fill.width = value - BORDER_THICKNESS * 2;
    }
    
    override public function set height(value:Number):void {
        bottomLightCanvas.height = value;
        border.height = value - 1;
        fill.height = value - BORDER_THICKNESS * 2 - 1;
    }
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.geom.Rectangle;
class IronCheckBoxUpIcon extends Sprite {
    
    private var bottomLightCanvas:Sprite;
    private var border:Sprite;
    private var fill:Sprite;
    
    private static const WIDTH:Number = 14;
    private static const HEIGHT:Number = 15;
    private static const BORDER_THICKNESS:Number = 1;
    private static const RADIUS:Number = 2;
    
    public function IronCheckBoxUpIcon():void {
        var colors:Array;
        var alphas:Array;
        var ratios:Array;
        var matrix:Matrix;
        
        bottomLightCanvas = new Sprite();
        bottomLightCanvas.graphics.beginFill(0, 1);
        bottomLightCanvas.graphics.drawRoundRect(0, 0, WIDTH, HEIGHT, RADIUS * 2);
        bottomLightCanvas.graphics.endFill();
        addChild(bottomLightCanvas);
        
        var bottomLight:DropShadowFilter = new DropShadowFilter();
        bottomLight.blurX = 0;
        bottomLight.blurY = 1;
        bottomLight.distance = 1;
        bottomLight.inner = true;
        bottomLight.angle = -90;
        bottomLight.strength = 0.4;
        bottomLight.knockout = true;
        bottomLight.color = 0xffffff;
        bottomLightCanvas.filters = [bottomLight];
        
        border = new Sprite();
        border.graphics.beginFill(0x000000, 0.5);
        border.graphics.drawRoundRect(0, 0, WIDTH, HEIGHT - 1, RADIUS * 2);
        border.graphics.endFill();
        addChild(border);
        
        colors = [0xeeeeee, 0xaaaaaa];
        alphas = [1, 1];
        ratios = [0x00, 0xff];
        matrix = new Matrix();
        matrix.createGradientBox(WIDTH - BORDER_THICKNESS * 2, HEIGHT - 1 - BORDER_THICKNESS * 2, Math.PI / 2, 0, 0);
        fill = new Sprite();
        fill.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        fill.graphics.drawRoundRect(0, 0, WIDTH - BORDER_THICKNESS * 2, HEIGHT - 1 - BORDER_THICKNESS * 2, (RADIUS - BORDER_THICKNESS) * 2);
        fill.graphics.endFill();
        fill.x = fill.y = BORDER_THICKNESS;
        addChild(fill);
        
        var fillLight:DropShadowFilter = new DropShadowFilter();
        fillLight.blurX = 0;
        fillLight.blurY = 1;
        fillLight.distance = 1;
        fillLight.inner = true;
        fillLight.angle = 90;
        fillLight.strength = 0.5;
        fillLight.color = 0xffffff;
        fill.filters = [fillLight];
    }
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.geom.Rectangle;
class IronCheckBoxSelectedUpIcon extends Sprite {
    
    private var bottomLightCanvas:Sprite;
    private var border:Sprite;
    private var fill:Sprite;
    
    private static const WIDTH:Number = 14;
    private static const HEIGHT:Number = 15;
    private static const BORDER_THICKNESS:Number = 1;
    private static const RADIUS:Number = 2;
    
    public function IronCheckBoxSelectedUpIcon():void {
        var colors:Array;
        var alphas:Array;
        var ratios:Array;
        var matrix:Matrix;
        
        bottomLightCanvas = new Sprite();
        bottomLightCanvas.graphics.beginFill(0, 1);
        bottomLightCanvas.graphics.drawRoundRect(0, 0, WIDTH, HEIGHT, RADIUS * 2);
        bottomLightCanvas.graphics.endFill();
        addChild(bottomLightCanvas);
        
        var bottomLight:DropShadowFilter = new DropShadowFilter();
        bottomLight.blurX = 0;
        bottomLight.blurY = 1;
        bottomLight.distance = 1;
        bottomLight.inner = true;
        bottomLight.angle = -90;
        bottomLight.strength = 0.4;
        bottomLight.knockout = true;
        bottomLight.color = 0xffffff;
        bottomLightCanvas.filters = [bottomLight];
        
        border = new Sprite();
        border.graphics.beginFill(0x000000, 0.5);
        border.graphics.drawRoundRect(0, 0, WIDTH, HEIGHT - 1, RADIUS * 2);
        border.graphics.endFill();
        addChild(border);
        
        colors = [0xeeeeee, 0xaaaaaa];
        alphas = [1, 1];
        ratios = [0x00, 0xff];
        matrix = new Matrix();
        matrix.createGradientBox(WIDTH - BORDER_THICKNESS * 2, HEIGHT - 1 - BORDER_THICKNESS * 2, Math.PI / 2, 0, 0);
        fill = new Sprite();
        fill.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        fill.graphics.drawRoundRect(0, 0, WIDTH - BORDER_THICKNESS * 2, HEIGHT - 1 - BORDER_THICKNESS * 2, (RADIUS - BORDER_THICKNESS) * 2);
        fill.graphics.endFill();
        fill.x = fill.y = BORDER_THICKNESS;
        addChild(fill);
        
        var fillLight:DropShadowFilter = new DropShadowFilter();
        fillLight.blurX = 0;
        fillLight.blurY = 1;
        fillLight.distance = 1;
        fillLight.inner = true;
        fillLight.angle = 90;
        fillLight.strength = 0.5;
        fillLight.color = 0xffffff;
        fill.filters = [fillLight];
        
        var check:Sprite = new Sprite();
        check.graphics.lineStyle(0x000000);
        check.graphics.moveTo(3, 5);
        check.graphics.lineTo(6.5, 10);
        check.graphics.lineTo(13, 1);
        addChild(check);
    }
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.geom.Rectangle;
class IronCheckBoxSelectedDownIcon extends Sprite {
    
    private var bottomLightCanvas:Sprite;
    private var border:Sprite;
    private var fill:Sprite;
    
    private static const WIDTH:Number = 14;
    private static const HEIGHT:Number = 15;
    private static const BORDER_THICKNESS:Number = 1;
    private static const RADIUS:Number = 2;
    
    public function IronCheckBoxSelectedDownIcon():void {
        var colors:Array;
        var alphas:Array;
        var ratios:Array;
        var matrix:Matrix;
        
        bottomLightCanvas = new Sprite();
        bottomLightCanvas.graphics.beginFill(0, 1);
        bottomLightCanvas.graphics.drawRoundRect(0, 0, WIDTH, HEIGHT, RADIUS * 2);
        bottomLightCanvas.graphics.endFill();
        addChild(bottomLightCanvas);
        
        var bottomLight:DropShadowFilter = new DropShadowFilter();
        bottomLight.blurX = 0;
        bottomLight.blurY = 1;
        bottomLight.distance = 1;
        bottomLight.inner = true;
        bottomLight.angle = -90;
        bottomLight.strength = 0.4;
        bottomLight.knockout = true;
        bottomLight.color = 0xffffff;
        bottomLightCanvas.filters = [bottomLight];
        
        border = new Sprite();
        border.graphics.beginFill(0x000000, 0.5);
        border.graphics.drawRoundRect(0, 0, WIDTH, HEIGHT - 1, RADIUS * 2);
        border.graphics.endFill();
        addChild(border);
        
        colors = [0x888888, 0xaaaaaa];
        alphas = [1, 1];
        ratios = [0x00, 0xff];
        matrix = new Matrix();
        matrix.createGradientBox(WIDTH - BORDER_THICKNESS * 2, HEIGHT - 1 - BORDER_THICKNESS * 2, Math.PI / 2, 0, 0);
        fill = new Sprite();
        fill.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        fill.graphics.drawRoundRect(0, 0, WIDTH - BORDER_THICKNESS * 2, HEIGHT - 1 - BORDER_THICKNESS * 2, (RADIUS - BORDER_THICKNESS) * 2);
        fill.graphics.endFill();
        fill.x = fill.y = BORDER_THICKNESS;
        addChild(fill);
        
        var check:Sprite = new Sprite();
        check.graphics.lineStyle(0x000000);
        check.graphics.moveTo(3, 5);
        check.graphics.lineTo(6.5, 10);
        check.graphics.lineTo(13, 1);
        addChild(check);
    }
}

import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.geom.Rectangle;
class SearchTextInputUpSkin extends Sprite {
    
    private var _width:Number = 100;
    private var _height:Number = 100;
    
    private var back:Sprite;
    private var icon:Sprite;
    
    private const RADIUS:Number = 12;
    private const ICON_Y:Number = 5;
    
    public function SearchTextInputUpSkin():void {
        back = new Sprite();
        back.graphics.beginFill(0xffffff);
        back.graphics.drawRoundRect(0, 0, 100, 100, RADIUS * 2);
        back.graphics.endFill();
        back.scale9Grid = new Rectangle(RADIUS, RADIUS, 100 - RADIUS * 2, 100 - RADIUS * 2);
        back.filters = [new DropShadowFilter(0.5, 90, 0x000000, 1, 3, 3, 1, 1, true)];
        addChild(back);
        
        icon = new Sprite();
        icon.graphics.beginFill(0x444444);
        icon.graphics.drawCircle(5, 5, 5);
        icon.graphics.endFill();
        icon.graphics.beginFill(0xffffff);
        icon.graphics.drawCircle(5, 5, 3);
        icon.graphics.endFill();
        icon.graphics.lineStyle(2, 0x444444);
        icon.graphics.moveTo(9, 9);
        icon.graphics.lineTo(12, 12);
        addChild(icon);
        
        setSize(_width, _height);
    }
    
    override public function get width():Number {
        return _width;
    }
    override public function set width(value:Number):void {
        setSize(value, _height);
    }
    
    override public function get height():Number {
        return _height;
    }
    override public function set height(value:Number):void {
        setSize(_width, value);
    }
    
    public function setSize(width:Number, height:Number):void {
        if (width == _width && height == _height) {
            return;
        }
        _width = width;
        _height = height;
        
        back.x = -20;
        back.y = 0;
        back.width = _width + 20 + RADIUS;
        back.height = _height;
        
        icon.x = -14;
        icon.y = (_height - icon.height) / 2;
    }
    
}

import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.geom.Rectangle;
class SearchTextInputFocusRectSkin extends Sprite {
    
    private var _width:Number = 100;
    private var _height:Number = 100;
    
    private var back:Sprite;
    
    private const RADIUS:Number = 12;
    
    public function SearchTextInputFocusRectSkin():void {
        back = new Sprite();
        back.graphics.beginFill(0);
        back.graphics.drawRoundRect(0, 0, 100, 100, RADIUS * 2);
        back.graphics.endFill();
        back.scale9Grid = new Rectangle(RADIUS, RADIUS, 100 - RADIUS * 2, 100 - RADIUS * 2);
        back.filters = [new DropShadowFilter(0, 0, 0x88aee1, 1, 8, 8, 2, 1, false, true, true)];
        addChild(back);
        
        setSize(_width, _height);
    }
    
    override public function get width():Number {
        return _width;
    }
    override public function set width(value:Number):void {
        setSize(value, _height);
    }
    
    override public function get height():Number {
        return _height;
    }
    override public function set height(value:Number):void {
        setSize(_width, value);
    }
    
    public function setSize(width:Number, height:Number):void {
        if (width == _width && height == _height) {
            return;
        }
        _width = width;
        _height = height;
        
        back.x = -20;
        back.y = 0;
        back.width = _width + 20 + RADIUS;
        back.height = _height;
    }
    
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.geom.Matrix;
class IronScrollUpArrowUpSkin extends Sprite {
    
    public function IronScrollUpArrowUpSkin():void {
        var colors:Array;
        var alphas:Array;
        var ratios:Array;
        var matrix:Matrix;
        
        colors = [0xffffff, 0xdddddd];
        alphas = [1, 1];
        ratios = [0, 255];
        matrix = new Matrix();
        matrix.createGradientBox(15, 14, 0, 0, 0);
        graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        graphics.drawRect(0, 0, 15, 14);
        graphics.endFill();
        
        graphics.beginFill(0xcccccc);
        graphics.drawRect(0, 0, 1, 14);
        graphics.endFill();
        
        graphics.beginFill(0x333333);
        graphics.moveTo(3, 10);
        graphics.lineTo(12, 10);
        graphics.lineTo(7.5, 4);
        graphics.endFill();
    }
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.geom.Matrix;
class IronScrollUpArrowDownSkin extends Sprite {
    
    public function IronScrollUpArrowDownSkin():void {
        var colors:Array;
        var alphas:Array;
        var ratios:Array;
        var matrix:Matrix;
        
        colors = [0xffffff, 0xdddddd];
        alphas = [1, 1];
        ratios = [0, 255];
        matrix = new Matrix();
        matrix.createGradientBox(15, 14, 0, 0, 0);
        graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        graphics.drawRect(0, 0, 15, 14);
        graphics.endFill();
        
        graphics.beginFill(0xcccccc);
        graphics.drawRect(0, 0, 1, 14);
        graphics.endFill();
        
        graphics.beginFill(0x939ebb);
        graphics.moveTo(3, 10);
        graphics.lineTo(12, 10);
        graphics.lineTo(7.5, 4);
        graphics.endFill();
    }
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.geom.Rectangle;
class IronScrollTrackSkin extends Sprite {
    
    private var _width:Number = 0;
    private var _height:Number = 0;
    
    private var shadow:Sprite;
    private var topShadow:Sprite;
    private var bottomShadow:Sprite;
    private var cover:Sprite;
    
    private static const RADIUS:Number = 15 / 2;
    
    ////////////////////////////////////////////////////////////
    //////////////コンストラクタ
    ////////////////////////////////////////////////////////////
    
    public function IronScrollTrackSkin():void {
        var colors:Array;
        var alphas:Array;
        var ratios:Array;
        var matrix:Matrix;
        
        colors = [0xbbbbbb, 0xeeeeee, 0xdddddd];
        alphas = [1, 1, 1];
        ratios = [0, 150, 255];
        matrix = new Matrix();
        matrix.createGradientBox(100, 100, 0, 0, 0);
        shadow = new Sprite();
        shadow.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        shadow.graphics.drawRect(0, 0, 100, 100);
        shadow.graphics.endFill();
        addChild(shadow);
        
        colors = [0x000000, 0x000000];
        alphas = [0.2, 0];
        ratios = [0, 255];
        matrix = new Matrix();
        matrix.createGradientBox(100, RADIUS, Math.PI / 2, 0, 0);
        topShadow = new Sprite();
        topShadow.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        topShadow.graphics.drawRect(0, 0, 100, RADIUS);
        topShadow.graphics.endFill();
        addChild(topShadow);
        
        colors = [0x000000, 0x000000];
        alphas = [0, 0.2];
        ratios = [0, 255];
        matrix = new Matrix();
        matrix.createGradientBox(100, RADIUS, Math.PI / 2, 0, 0);
        bottomShadow = new Sprite();
        bottomShadow.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        bottomShadow.graphics.drawRect(0, 0, 100, RADIUS);
        bottomShadow.graphics.endFill();
        addChild(bottomShadow);
        
        colors = [0xffffff, 0xdddddd];
        alphas = [1, 1];
        ratios = [0, 255];
        matrix = new Matrix();
        matrix.createGradientBox(100, 100, 0, 0, 0);
        cover = new Sprite();
        cover.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        cover.graphics.drawRect(0, 0, 100, 100);
        cover.graphics.drawRoundRect(0, 0, 100, 100, RADIUS * 2);
        cover.graphics.endFill();
        cover.graphics.beginFill(0xcccccc);
        cover.graphics.drawRect(0, 0, 1, 100);
        cover.graphics.endFill();
        cover.scale9Grid = new Rectangle(RADIUS, RADIUS, 100 - RADIUS * 2, 100 - RADIUS * 2);
        addChild(cover);
        
        setSize(15, 100);
    }
    
    ////////////////////////////////////////////////////////////
    //////////////プロパティ
    ////////////////////////////////////////////////////////////
    
    //______________ width ______________//
    override public function get width():Number {
        return _width;
    }
    override public function set width(value:Number):void {
        setSize(value, _height);
    }
    
    //______________ height ______________//
    override public function get height():Number {
        return _height;
    }
    override public function set height(value:Number):void {
        setSize(_width, value);
    }
    
    ////////////////////////////////////////////////////////////
    //////////////メソッド
    ////////////////////////////////////////////////////////////
    
    //______________ setSize ______________//
    private function setSize(width:Number, height:Number):void {
        if (width == _width && height == _height) {
            return;
        }
        _width = width;
        _height = height;
        
        shadow.width = _width;
        shadow.height = _height;
        
        topShadow.width = _width;
        
        bottomShadow.width = _width;
        bottomShadow.y = _height - RADIUS;
        
        cover.width = _width;
        cover.height = _height;
    }
    
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.geom.Matrix;
import flash.geom.Rectangle;
class IronScrollThumbUpSkin extends Sprite {
    
    private var RADIUS:Number = 13 / 2;
    private var MARGIN:Number = 1;
    private var BORDER_THICKNESS:Number = 1;
    
    public function IronScrollThumbUpSkin():void {
        var colors:Array;
        var alphas:Array;
        var ratios:Array;
        var matrix:Matrix;
        
        graphics.beginFill(0, 0);
        graphics.drawRect(0, 0, 100, 100);
        graphics.endFill();
        
        graphics.beginFill(0x939ebb);
        graphics.drawRoundRect(MARGIN, MARGIN, 100 - MARGIN * 2, 100 - MARGIN * 2, RADIUS * 2);
        graphics.endFill();
        
        colors = [0xb7bfcd, 0x8d97b3];
        alphas = [1, 1];
        ratios = [0, 255];
        matrix = new Matrix();
        matrix.createGradientBox(100 - (MARGIN + BORDER_THICKNESS) * 2, 100 - (MARGIN + BORDER_THICKNESS) * 2, 0, 0, 0);
        graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        graphics.drawRoundRect(MARGIN + BORDER_THICKNESS, MARGIN + BORDER_THICKNESS, 100 - (MARGIN + BORDER_THICKNESS) * 2, 100 - (MARGIN + BORDER_THICKNESS) * 2, (RADIUS - BORDER_THICKNESS) * 2);
        graphics.endFill();
        
        scale9Grid = new Rectangle(MARGIN + RADIUS, MARGIN + RADIUS, 100 - (MARGIN + RADIUS) * 2, 100 - (MARGIN + RADIUS) * 2);
    }
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.geom.Matrix;
class IronScrollDownArrowUpSkin extends Sprite {
    
    public function IronScrollDownArrowUpSkin():void {
        var colors:Array;
        var alphas:Array;
        var ratios:Array;
        var matrix:Matrix;
        
        colors = [0xffffff, 0xdddddd];
        alphas = [1, 1];
        ratios = [0, 255];
        matrix = new Matrix();
        matrix.createGradientBox(15, 14, 0, 0, 0);
        graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        graphics.drawRect(0, 0, 15, 14);
        graphics.endFill();
        
        graphics.beginFill(0xcccccc);
        graphics.drawRect(0, 0, 1, 14);
        graphics.endFill();
        
        graphics.beginFill(0x333333);
        graphics.moveTo(3, 4);
        graphics.lineTo(12, 4);
        graphics.lineTo(7.5, 10);
        graphics.endFill();
    }
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.geom.Matrix;
class IronScrollDownArrowDownSkin extends Sprite {
    
    public function IronScrollDownArrowDownSkin():void {
        var colors:Array;
        var alphas:Array;
        var ratios:Array;
        var matrix:Matrix;
        
        colors = [0xffffff, 0xdddddd];
        alphas = [1, 1];
        ratios = [0, 255];
        matrix = new Matrix();
        matrix.createGradientBox(15, 14, 0, 0, 0);
        graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
        graphics.drawRect(0, 0, 15, 14);
        graphics.endFill();
        
        graphics.beginFill(0xcccccc);
        graphics.drawRect(0, 0, 1, 14);
        graphics.endFill();
        
        graphics.beginFill(0x939ebb);
        graphics.moveTo(3, 4);
        graphics.lineTo(12, 4);
        graphics.lineTo(7.5, 10);
        graphics.endFill();
    }
}
