/**
 * Copyright 1031no ( http://wonderfl.net/user/1031no )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ivKY
 */

// forked from 9re's flash on 2010-2-22
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.geom.Rectangle;
    import flash.events.Event;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.core.easing.EaseNone;
	import org.libspark.betweenas3.core.easing.IEasing;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.tweens.IObjectTween;
	import org.libspark.betweenas3.tweens.ITween;
	import mx.utils.HSBColor;
	    
    import flash.utils.Timer;
    public class FlashTest extends Sprite {
    		private static const NUM_DIVIDE:int = 10;
    		private const TIMER_INTEVAL:Number = 0.5;
    		private var _points:Array = [];
    		private var _samplePoints:Array;
    		private var _drawAlpha:Number = 0.25;
    		
        public function FlashTest() {
        	
        		for (var i:int = 0; i < 6; ++i) {
        			makePoint(50 + 365 * Math.random(), 50 + 365 * Math.random());
        		}
 	       	drawCurves();
 	       	
	        	
           stage.addEventListener(MouseEvent.CLICK, mouseHandler);
           stage.addEventListener(Event.ENTER_FRAME, function():void{drawAuxLines();});
            makeTweens();
        }
        
        private function makeTweens():void {
        		var tweens:Array = [];
        		var tween:ITween;
        		var sts:Array;
        		var p:Point;
        		
        		for (var i:int = 0; i < _points.length; ++i) {
        			p = _points[i];
        			sts = [];
        			var len:int = 4 + 4 * Math.random();
        			for (var j:int = 0; j < len; ++j)
        				sts.push(BetweenAS3.to(p, { x : 50 + 365 * Math.random(), y : 50 + 365 * Math.random()}, 1.5));
	        		tween = BetweenAS3.serialTweens(sts);
	        		tweens.push(tween);
        		}
        		
        		var t:ITween = BetweenAS3.serial(
        						BetweenAS3.parallelTweens(tweens),
        						BetweenAS3.delay(BetweenAS3.func(function ():void {
        							graphics.clear();
        						}), TIMER_INTEVAL));
        						t.stopOnComplete = false;
        						t.play();
        }
        
        private function makePoint(mouseX:Number, mouseY:Number):Point {
            	var point:Point = new Point(mouseX, mouseY);
            	point.addEventListener(MouseEvent.MOUSE_DOWN, function (e:MouseEvent):void {
            		_drawAlpha = 0.25;
            		e.stopImmediatePropagation();
            		stage.addEventListener(MouseEvent.MOUSE_MOVE, whileDragging);
            		var p:Point = e.currentTarget as Point;
            		p.startDrag(false, new Rectangle(0, 0, 465, 465));
            	});
            	point.addEventListener(MouseEvent.MOUSE_UP, function (e:Event):void {
            		_drawAlpha = 0.6
            		var p:Point = e.currentTarget as Point;
            		p.stopDrag();
            		stage.removeEventListener(MouseEvent.MOUSE_MOVE, whileDragging);
            		drawCurves();
            	});
            		
            	function whileDragging(e:MouseEvent):void {
            		e.updateAfterEvent();
            		drawAuxLines();
            	}
            	addChild(point);
            	_points.push(point);
            	drawCurves();
            	
            	return point;
        }
        
        private function mouseHandler(e:MouseEvent):void {
        		makePoint(mouseX, mouseY);
        }
        
        // draw curves
        private function drawCurves():void {
        		graphics.clear();
        		graphics.lineStyle(2, 0);
        		var stack:Array = [];
        		var controlPoint:Point;
        		for (var i:int = 0; i < _points.length; ++i) {
        			var p:Point = _points[i];
        			switch(i % 3) {
        			case 0:
        				graphics.moveTo(p.x, p.y);
        				break;
        			case 1:
        				stack.push(p);
        				break;
        			case 2:
        				controlPoint = stack.pop();
        				graphics.curveTo(controlPoint.x, controlPoint.y, p.x, p.y);
        				break;
        			default:
        				break;
        			}
        		}
        		
        		drawAuxLines();
        }
        
        
        private function drawAuxLines():void {
        		var start:Point;
        		var control:Point;
        		var end:Point;
        		var p:Point, q:Point;
        		var i:int = 0;
        		var j:int;
        		graphics.lineStyle(1, 0, _drawAlpha);
        		while (i + 2 < _points.length) {
        			start = _points[i++];
        			control = _points[i++];
        			end = _points[i++];
        			
        			for (j = 0; j <= NUM_DIVIDE; ++j) {
        				p = this.divideLineAtRatio(control, end , 1 - j / NUM_DIVIDE);
        				q = this.divideLineAtRatio(control, start, j / NUM_DIVIDE);
        				graphics.moveTo(p.x, p.y);
        				graphics.lineTo(q.x, q.y);
        			}
        			
        		}
        }
        
        // dividing line
        private function divideLineAtRatio(p0:Point, p1:Point, ratio:Number):Point {
        		var p:Point = new Point(f(p0.x, p1.x, ratio), f(p0.y, p1.y, ratio), false);
        		
        		function f(t0:Number, t1:Number, r:Number):Number {
        			return t0 * (1 - r) + t1 * r;
        		}
        	
        		return p;
        }
    }
}

import flash.display.Sprite;
class Point extends Sprite {
	private static const SIZE:int = 5;
	public function Point(x:Number, y:Number, drawCircle:Boolean = false) {
		this.x = x;
		this.y = y;
		
		if (drawCircle) {
			graphics.beginFill(0);
			graphics.drawCircle(0, 0, SIZE);
			graphics.endFill();
		}
		
		buttonMode = true;
		tabEnabled = false;
	}
}
	