/**
 * Copyright moonthug ( http://wonderfl.net/user/moonthug )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iuQ6
 */

package {
    import flash.display.Sprite;
    import flash.geom.Point;
    
    public class TriangleZ extends Sprite {
        
        private var _pointArray:Array;
        
        public function TriangleZ() {
            _createGrid();
        }
        
        private function _createGrid():void
        {
            var initPoint:Point = new Point(stage.stageWidth/2, stage.stageHeight/2);
            var firstPoint:Point = new Point(20,20);
            
            firstPoint = initPoint.add(firstPoint);
            
            _pointArray = new Array(initPoint, firstPoint);
            
            graphics.lineStyle(1, 0x000000);
            graphics.moveTo(initPoint.x, initPoint.y);
            graphics.lineTo(firstPoint.x, firstPoint.y);
                        
            for( var i:int = 1; i < 100; i++ )
            {
                _drawTriangle(i);
            }
        }
        
        private function _drawTriangle(p:int):void
        {
            var randomX:int = 20 - Math.floor(Math.random() * 40);
            var randomY:int = 20 - Math.floor(Math.random() * 40);
            var newPoint:Point = new Point(randomX, randomY);
            
            newPoint = newPoint.add(_pointArray[p]);
            
            graphics.moveTo(_pointArray[p].x, _pointArray[p].y);
            graphics.lineTo(newPoint.x, newPoint.y);
            
            _pointArray.push(newPoint);
        }
    }
}