/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iuIt
 */

package {
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {

            stage.quality = StageQuality.LOW;
            stage.addEventListener(Event.ENTER_FRAME, onEnter);            
        }//ctor
        
        public var myDraw:xVertDraw = new xVertDraw();
        
        public var gt:int = 0;
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);

            var ang:Number;
            ang = Math.sin(gt*0.05)*256;
/*
            myDraw.drawLine(graphics, -100, 0, -200, 100, 0, -200);
            myDraw.drawLine(graphics, -100, 0, -200, -100, 0, 200);
            myDraw.drawLine(graphics, 100, 0, -200, 100, 0, 200);
            
            myDraw.drawLine(graphics, 0,50, 0,  0, 0, -1000);
*/
            //myDraw.drawBox(graphics, -50,-50,-150+ang, 50,50,-100+ang);
 
 
            var i:int; var k:int;
            for (k = -8; k < 8; k++)
            {
              for (i = -8; i < 8; i++)  
              {
                myDraw.drawBox(graphics, k*64-16, -16+ang ,-150+i*64-16,
                 k*64+16,16+ang,-150+i*64+16);
             
              }//nexti
            }//nextk 
            
            //myDraw.addVert(0,0,-50,8);
           // myDraw.renderVert(graphics);
            
            gt += 1;
        }//onenter
        
        
    }//classend
}

import flash.display.Graphics;


internal class xVert
{
  
  public var sx:Number = 0;  public var sy:Number = 0;
  public var sr:Number = 0;
  public var sw:Number = 1;
  public var sortCode:int = 0;
  
}//xvert 


internal class xVertDraw 
{
  public var vecVert:Vector.<xVert>;
  public var it:int = 0;
  
  public var projMat:Vector.<Number> = Vector.<Number>([1, 0, 0, 0, 0, 1, 0, 0,  0, 0, 1, 0, 0, 0, 0, 1]); 
  public var rendw:Number = 465 * 0.5;
  public var rendh:Number = 465 * 0.5;
  
  
  public function xVertDraw()
  {
    init(1024);
    setProjMat(projMat, 90, 1, 1, 1000);
  }//ctor  
  
  public function init(num:int):void
  {
    vecVert = new Vector.<xVert>(num, false);
    var i:int;   for (i = 0; i < num; i++) { vecVert[i] = new xVert(); }
  }//init

 public function drawBox(g:Graphics, minx:Number, miny:Number, minz:Number,
      maxx:Number, maxy:Number, maxz:Number):void
        {
          drawLine(g,minx, miny, minz,   maxx, miny, minz);
          drawLine(g,minx, maxy, minz,   maxx, maxy, minz);
          drawLine(g,minx, miny, maxz,   maxx, miny, maxz);
          drawLine(g,minx, maxy, maxz,   maxx, maxy, maxz);
          
          drawLine(g,minx, miny, minz,   minx, maxy, minz);
          drawLine(g,maxx, miny, minz,   maxx, maxy, minz);
          drawLine(g,minx, miny, maxz,   minx, maxy, maxz);
          drawLine(g,maxx, miny, maxz,   maxx, maxy, maxz);
          
          drawLine(g,minx, miny, minz,   minx, miny, maxz);
          drawLine(g,maxx, miny, minz,   maxx, miny, maxz);
          drawLine(g,minx, maxy, minz,   minx, maxy, maxz);
          drawLine(g,maxx, maxy, minz,   maxx, maxy, maxz);
        }//drawbox
        
  public function drawLine(g:Graphics, ax:Number, ay:Number, az:Number,
  bx:Number, by:Number, bz:Number):void
  {
    var mat:Vector.<Number>;
    var sx0:Number, sy0:Number, sz0:Number, w0:Number; 
    var sx1:Number, sy1:Number, sz1:Number, w1:Number; 
     mat = projMat;

    w0 = ax * mat[3] + ay * mat[7] + az * mat[11] + mat[15];
    w1 = bx * mat[3] + by * mat[7] + bz * mat[11] + mat[15];
    if (w0 <= 0 && w1 <= 0) { return; }

    sx0 = ax * mat[0] + ay * mat[4] + az * mat[8] + mat[12];
    sy0 = ax * mat[1] + ay * mat[5] + az * mat[9] + mat[13];
    //sz0 = ax * mat[2] + ay * mat[6] + az * mat[10] + mat[14];

    sx1 = bx * mat[0] + by * mat[4] + bz * mat[8] + mat[12];
    sy1 = bx * mat[1] + by * mat[5] + bz * mat[9] + mat[13];
    //sz1 = bx * mat[2] + by * mat[6] + bz * mat[10] + mat[14];
 
    sx0 /= w0; sy0 /= w0;

    //projection fix
    if (w0 < 0.0)
    { if (sx0 > 0) {  sx0 = -1.0 - sx0;  } else { sx0 = 1.0 - sx0; }
      if (sy0 > 0) {  sy0 = -1.0 - sy0; }  else { sy0 = 1.0 - sy0; }          
    }//endif  
    sx0 *= rendw;  sy0 *= -rendh;    sx0 += rendw;  sy0 += rendh;
    
    sx1 /= w1; sy1 /= w1;
    //projection fix
    if (w1 < 0.0)
    { if (sx1 > 0) {  sx1 = -1.0 - sx1;  } else { sx1 = 1.0 - sx1; }
      if (sy1 > 0) {  sy1 = -1.0 - sy1; }  else { sy1 = 1.0 - sy1; }          
    }//endif  
    sx1 *= rendw;  sy1 *= -rendh;    sx1 += rendw;  sy1 += rendh;    
    
    g.moveTo(sx0, sy0);    g.lineTo(sx1, sy1);        
  }//drawline  



  
  public function addVert(ax:Number, ay:Number, az:Number, rad:Number):void
  {
    var a:xVert;  var mat:Vector.<Number>;    var m:Number;
    var sx:Number;        var sy:Number;      var sz:Number;
    var w:Number; 
    mat = projMat;
   
    w = ax * mat[3] + ay * mat[7] + az * mat[11] + mat[15];
    if (w <= 0) { return; }
    
    sx = ax * mat[0] + ay * mat[4] + az * mat[8] + mat[12];
    sy = ax * mat[1] + ay * mat[5] + az * mat[9] + mat[13];
    sz = ax * mat[2] + ay * mat[6] + az * mat[10] + mat[14];
   
    sx /= w; sy /= w;
    sx *= rendw;            sy *= -rendh;
    sx += rendw;            sy += rendh;
        
    m = (1 / w) * rendh * rad; 
        
    a = vecVert[it]; it += 1; if (it >= vecVert.length) { it = vecVert.length - 1; }
    a.sx = sx;   a.sy = sy;   a.sw = w;    a.sr = m;
    a.sortCode = 0x0FffFFff - int(sz);    
  }//addvert
    
  public function renderVert(g:Graphics):void
  {
    //g.lineStyle(2, 0);
    var i:int; var num:int; var a:xVert;
    num = it;    sortVert(vecVert, num);
    for (i = 0; i < num; i++)
    { a = vecVert[i];
      g.beginFill(0x808080, 1);
        g.drawCircle(a.sx, a.sy, a.sr);
      g.endFill();
    }//nexti 
    it = 0;
  }//rendervert
    
    
    public function sortVert(vec:Vector.<xVert>, num:int):void
    {  radixSortVert(vec, num);    }//sortvert 
     
    public var tempVec:Vector.<xVert> = new Vector.<xVert>(8192, false);
    public var tempBuck:Vector.<int> = new Vector.<int>(256, false);
    public function radixSortVert(vec:Vector.<xVert>, num:int):void
    {
      var a:xVert;          var temp:Vector.<xVert>;          var buck:Vector.<int>;
      var i:int;          var k:uint;          var shift:int;          var g:int;
      if (vec.length < num) { num = vec.length; }
      temp = tempVec;    if (temp.length < num) { return; }
      buck = tempBuck;    shift = 0;       
      while (shift < 32)  {   
        for (k = 0; k < 256; k++) { buck[k] = 0; }      //reset bucket
        for (i = 0; i < num; i++)  {  g = (vec[i].sortCode >> shift) &0xFF;  buck[g]++; }              
        for (i = 1; i < 256; i++)   {  buck[i] += buck[i - 1];  }               
        for (i = num - 1; i >= 0; i--)  { g = (vec[i].sortCode >> shift) &0xFF;  temp[--buck[g] ] = vec[i];  }        
        for (i = 0; i < num; i++) { vec[i] = temp[i];   }
        shift += 8; 
      }//wend
    }//radixsort  
  
    public static function setProjMat(vec:Vector.<Number>,
     fovdeg:Number = 60.0, aspect:Number=1.0, nearp:Number = 1.0, farp:Number=1000.0):void
    {   var f:Number;   var i:int;
        for (i = 0; i < 16; i++) { vec[i] = 0.0;  } 
        f = 1.0 / Math.tan( (fovdeg * (3.1415 / 180.0)) * 0.5 );
        if (nearp == 0) { nearp = 0.0001; }
        if (farp == 0) { farp = 0.0001; }
        vec[0] = f / aspect;          vec[5] = f;
        vec[10] = (farp + nearp) / (nearp - farp);
        vec[14] = (2.0 * farp * nearp) / (nearp - farp);
        vec[11] = -1.0;          vec[15] = 0.0;
    }//projmatrix
      
}//vertdraw