/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iuFp
 */

// forked from signedvoid's ff: flash on 2014-6-2 (non-flickering)
// forked from UnknownOpenID's flash on 2014-6-2
package {
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var image:Bitmap;
        private var text:TextField;
        private var generation:uint = 0;
        private var counter:int = 0;
        private var value:int = 0;
        
        public function FlashTest()
        {
            addEventListener(Event.ENTER_FRAME, Update);
            
            var w:int = stage.stageWidth;
            var h:int = stage.stageHeight;
            var sx:Number = 2;
            var sy:Number = 2;
            
            value = int( Math.random() * 100000 );
            
            image = new Bitmap(new BitmapData(w/sx,h/sy, false, 0xffffff));
            image.bitmapData.noise( value );
            image.filters = [ new BlurFilter(2,2) ];
            image.scaleX = sx;
            image.scaleY = sy;
            
            addChild(image);
            
            text = new TextField();
            text.autoSize = "left";
            text.textColor = 0X0;
            text.background = true;
            text.backgroundColor = 0xFFFFFF;
            text.defaultTextFormat = new TextFormat("arial", 12);
            addChild(text);
        }
        
        public function Update(event:Event):void
        {
            if( generation > 550 ) 
            {
                value = int( Math.random() * 100000 );
                image.bitmapData.noise(value);
                generation = 0;
                
                return;
            }
            
            
            for(var i:int = 0; i < 4; i++)    
            {
    
                var clone:Bitmap = new Bitmap(image.bitmapData.clone());
                clone.bitmapData.lock();
                var bitmapdata:BitmapData = image.bitmapData;
                var maxy:int = clone.height - 1;
                var maxx:int = clone.width - 1;
                for(var y:uint = 1; y < maxy; y++)
                {
                    for(var x:uint = 1; x < maxx; x++)
                    {
                        clone.bitmapData.setPixel(x, y,
                            (bitmapdata.getPixel(x - 1, y - 1) + bitmapdata.getPixel(x + 1, y + 1) + bitmapdata.getPixel(x + 1, y - 1) + bitmapdata.getPixel(x - 1, y + 1)) / 4)
                    }
                }
                image.bitmapData = clone.bitmapData;
            }
            
            text.text = "GEN: " + generation.toString() + "\nVAL: " + value.toString();
            
            generation += 1;
        }

    }
}