/**
 * Copyright rodrigocardozo ( http://wonderfl.net/user/rodrigocardozo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/it0mt
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import net.hires.debug.Stats;

    public class Particles extends Sprite
    {
        
        private var r    :Bitmap;
        private var c    :Sprite;
        private var b    :Sprite;
        private var _radius:int = 10;
        private var _rect    :Rectangle;
        private var _pt    :Point = new Point();
        
        public var stageWidth : int = stage.stageWidth - _radius;
        public var stageHeight : int = stage.stageHeight - _radius;

        private var particles : Array = new Array;
        private var particles_count : int = 300;
        
        
        
        public function Particles()
        {
            addEventListener( Event.ADDED_TO_STAGE, init );
        }
        
        private function init( e : Event ) : void
        {
            removeEventListener( Event.ADDED_TO_STAGE, init );
            
            var blur:Number = 16;
            c = new Sprite();
            c.filters = [new BlurFilter(8,8,2)];
            addChild(c);
            
            r = new Bitmap( new BitmapData( stage.stageWidth, stage.stageHeight, false, 0xFFFFFF ) );
            addChild(r);
            
            _rect = r.bitmapData.rect;
            
            for (var i : int = 0; i < particles_count; i++)
            {
                particles[i] = new Particle(_radius);
                particles[i].x = Math.random() * stageWidth;
                particles[i].y = Math.random() * stageHeight;
                particles[i].vx = Math.random() * 20 - 10;
                particles[i].vy = Math.random() * 20 - 10;

                addChild( particles[i] );
                
                particles[i].filters = [new BlurFilter(8,8,2)];
            }
            
            addEventListener(Event.ENTER_FRAME, loop);
            addChild(new Stats());
        }

        private function loop( e : Event ) : void
        {
        var distance : Object = {x:0, y:0};
        var impact : Object = {x:0, y:0};
        var impulse : Object = {x:0, y:0};
        var impulseHalf : Object = {x:0, y:0};

            var gravity : Object = {x: (mouseX - (stageWidth >> 1)) / stageWidth, y: (mouseY - (stageHeight >> 1)) / stageHeight };

            for ( var i : int = 0; i < particles_count; i++)
            {
                var particle : Particle = particles[i];
            
                for( var j : int = 0; j < particles_count; j++)
                {
                    var particle2 : Particle = particles[j];
                    
                    if (particle2 == particle)
                    continue;
                
                    distance.x = particle.x - particle2.x;
                    distance.y = particle.y - particle2.y;
                                
                    var length : Number = Math.sqrt(distance.x * distance.x + distance.y * distance.y);
                
                    if (length < 16)                    {                         
                        impact.x = particle2.vx - particle.vx; //) * particle.restitution;
                        impact.y = particle2.vy - particle.vy; //) * particle.restitution;
                     
                        impulse.x = particle2.x - particle.x;
                        impulse.y = particle2.y - particle.y;
                    
                        var mag : Number = Math.sqrt(impulse.x * impulse.x + impulse.y * impulse.y);
                    
                        if (mag > 0)
                        {
                            mag = 1 / mag;
                            impulse.x *= mag;
                            impulse.y *= mag;
                        }
                    
                        impulseHalf.x = impulse.x * .5;
                        impulseHalf.y = impulse.y * .5;
                                
                        particle.x -= impulseHalf.x;
                        particle.y -= impulseHalf.y;
                                
                        particle2.x += impulseHalf.x;
                        particle2.y += impulseHalf.y;
                            
                        var dot : Number = impact.x * impulse.x + impact.y * impulse.y;
                                
                        impulse.x *= dot;
                        impulse.y *= dot;
                                
                        particle.vx += impulse.x * .9; // * particle.restitution;
                        particle.vy += impulse.y * .9; // * particle.restitution;
                        particle2.vx -= impulse.x * .9; //particle.restitution;
                        particle2.vy -= impulse.y * .9; //particle.restitution;
                    }
                }
            
                particle.x += particle.vx += gravity.x;
                particle.y += particle.vy += gravity.y;
                
                if (particle.y < _radius || particle.y > stageHeight)
                {
                    particle.vy *= -.8;
                    particle.vx *= .98;
                }
                    
                particle.y = (particle.y < _radius) ? _radius : (particle.y > stageHeight) ? stageHeight : particle.y;
                    
                if (particle.x < _radius || particle.x > stageWidth)
                    particle.vx *= -.8;            
                    
                particle.x = (particle.x < _radius) ? _radius : (particle.x > stageWidth) ? stageWidth : particle.x;        
            }
            
            
            r.bitmapData.fillRect(_rect, 0x00FFFFFF);
            r.bitmapData.draw(c);
            r.bitmapData.threshold(r.bitmapData, _rect, _pt, "<", 0x00808080, 0xFF141414, 0x00808080, true);
        }
    }
}

import flash.display.Sprite;

class Particle extends Sprite
{
    public var vx : Number = 0;
    public var vy : Number = 0;

    public function Particle(radius:Number)
    {
        graphics.beginFill(0x000000);
        graphics.drawCircle(0,0,radius);
        graphics.endFill();
    }
}
