/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iseK
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    [SWF(frameRate=60, width=465, height=465)]
    public class Main extends Sprite
    {
        private var _newContainer :Container;
        
        public function Main()
        {
            stage.align = StageAlign.LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _newContainer = new Container(0, 0, stage.stageWidth, 360);
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(_newContainer);
            
            init();
        }
        
        public function init() :void
        {
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Container extends Sprite
{
    protected var _x :int;
    protected var _y :int;
    protected var _width :int;
    protected var _height :int;
    
    public static var expanded1:Boolean = false;
    public static var expanded2:Boolean = false;
    public static var expanded3:Boolean = false;
    
    private var _prevMouse :Point = new Point();
    private var _thisMouse :Point = new Point();
    private var _calcMouse :Point = new Point();
    
    private var _quizSprite :Quiz;
    private var _quizSprite2 :Quiz;
    private var _quizSprite3 :Quiz;
        
    public function Container($x:int, $y:int, $width:int, $height:int)
    {
        _x = $x;
        _y = $y;
        _width = $width;
        _height = $height;
        
        _quizSprite = new Quiz(_x + 93, _y + 31, _width - (93*2), _height/8);
        _quizSprite2 = new Quiz(_x + 93, _y + (31*3), _width - (93*2), _height/8);
        _quizSprite3 = new Quiz(_x + 93, _y + (31*5), _width - (93*2), _height/8);
        _quizSprite.name = "1";
        _quizSprite2.name = "2";
        _quizSprite3.name = "3";
            
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
        
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        addChild(_quizSprite);
        addChild(_quizSprite2);
        addChild(_quizSprite3);
            
        init();
    }
        
    public function init() :void
    {
        graphics.clear();
        graphics.beginFill(0x666666);
        graphics.drawRect(_x, _y, _width, _height);
        graphics.endFill();
    }
    
    public function expandChildren($:Object) :void
    {
        switch ($.name)
        {
            case "1":
                if (!Container.expanded1)
                {
                    Container.expanded1=true;
                    _quizSprite2.y += 31;
                    _quizSprite3.y += 31;
                }else{
                    Container.expanded1=false;
                    _quizSprite2.y -= 31;
                    _quizSprite3.y -= 31;
                }

            break;
            case "2":
            
                if (!Container.expanded2)
                {
                    Container.expanded2=true;
                    _quizSprite3.y += 31;
                }else{
                    Container.expanded2=false;
                    _quizSprite3.y -= 31;
                }
            
            break;
            case "3":
                
                if (!Container.expanded3)
                {
                    Container.expanded3=true;
                }else{
                    Container.expanded3=false;
                }
            
            break;
        }
    }
    
    public override function get x() :Number
    {return _x}
    public override function get y() :Number
    {return _y}
    public override function get width() :Number
    {return _width}
    public override function get height() :Number
    {return _height}
}

class Quiz extends Sprite
{
    protected var _x :int;
    protected var _y :int;
    protected var _width :int;
    protected var _height :int;
    
    private var _expanded :Boolean = false;
        
    public function Quiz($x:int, $y:int, $width:int, $height:int)
    {
        _x = $x;
        _y = $y;
        _width = $width;
        _height = $height;
            
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
        
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        //instantiate
            
        init();
        
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
        
    public function init() :void
    {
        graphics.clear();
        graphics.beginFill(0xCCCCCC);
        graphics.drawRect(_x, _y, _width, _height);
        graphics.endFill();
    }
    
    private function onMouseDown($e:MouseEvent) :void
    {
        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        alpha = 0.5;
    }
    
    private function onMouseUp($e:MouseEvent) :void
    {
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        alpha = 1;
        if(_expanded!=true){
            _expanded = true;
            height += 31;
        }else{
            _expanded = false;
            height -= 31;
        }
        Container(parent).expandChildren(this);
    }
    
    public override function get x() :Number
    {return _x}
    public override function get y() :Number
    {return _y}
    public override function get width() :Number
    {return _width}
    public override function get height() :Number
    {return _height}
    
    public override function set x($:Number) :void
    {_x = $; init()}
    public override function set y($:Number) :void
    {_y = $; init()}
    public override function set width($:Number) :void
    {_width = $; init()}
    public override function set height($:Number) :void
    {_height = $; init()}
}

class Output extends TextField
{
    private var _textFormat :TextFormat;
    
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _size :Number;
    protected var _color :Number;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $color:Number = 0, $size:Number = 14, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _font = $font;
        _size = $size;
        _color = $color;
        _content = $content;
        
        multiline = true;
        selectable = mouseEnabled = false;
        autoSize = TextFieldAutoSize.LEFT;
        antiAliasType = AntiAliasType.ADVANCED;
        _textFormat = new TextFormat(_font, _size, _color);
        defaultTextFormat = _textFormat;
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function _init() :void
    {
        x = _x;
        y = _y;
        appendText("\n"+_content);
    }
    
    public function get nWidth() :Number
    { return width }

    public function set font($:String) :void
    { _font = $; _init() }
}