/**
 * Copyright sofe ( http://wonderfl.net/user/sofe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/irks
 */

//ellipse rotate
 
package
{
    import flash.text.Font;
    import flash.display.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.net.*;
    import flash.geom.*;
    import flash.system.*;
 
    public class Main extends Sprite
    {
        
        
        private var mySprite:Sprite = new Sprite();
        private var myGraphics:Graphics = mySprite.graphics;
        private  var nThickness:Number = 1;
        private var nColor:uint = 0x000000;
        private var nAlpha:Number = 1.0;
        private var nPixcelHinting:Boolean = true;
        private var nFill:uint = 0x000000;
        private var nX:Number;
        private var nY:Number;
        private var nEllipseX:Number = 20;
        private var nEllipseY:Number = 20;
        private var nSinX:int = 0;
        private var nCosY:int = 0;
        private var nDi:int = 20;
        private var nAngle:int = 10; 
        
        private const WIDTH:int = 500; // 幅
        private const HEIGHT:int = 500; // 高さ
        private var url:String = "http://assets.wonderfl.net/images/related_images/7/7c/7c39/7c390c254a3528f15f927c059cdb9bccb3438544";
        private var bd:BitmapData = new BitmapData(WIDTH, HEIGHT); 
 
        //メイン関数        
        public function Main(){                        
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);    
            loader.load(new URLRequest(url), new LoaderContext(true)); 
            stage.addEventListener(MouseEvent.MOUSE_DOWN, xBeginEllipse);
            stage.addEventListener(MouseEvent.MOUSE_UP, xEndEllipse);             
        }
        
        //画像ロード 
        private function initHandler(event:Event):void{
            var loader:Loader = event.currentTarget.loader;
            var matrix:Matrix = new Matrix();
            matrix.scale(WIDTH / loader.width, HEIGHT / loader.height); 
            bd.draw(loader);
            matrix = new Matrix();
            var destbd:BitmapData = new BitmapData(bd.width, bd.height);
            destbd.draw(bd);
            addChild(new Bitmap(destbd));
            addChild(mySprite);
        }
       
       //描画開始 
       private  function xBeginEllipse(eventObject:MouseEvent):void{   
            myGraphics.lineStyle(nThickness, nColor, nAlpha, nPixcelHinting);    
            nX = mouseX;
            nY = mouseY;
            stage.addEventListener(Event.ENTER_FRAME, xDrawEllipse);   
        } 
        
        //描画
         private function xDrawEllipse(eventObject:Event):void{          
            var  nDiX:Number =  Math.sin(nSinX*(Math.PI/180))*nDi;
            var  nDiY:Number = Math.cos(nCosY*(Math.PI/180))*nDi;  
            var posX:Number = mouseX - nEllipseX / 2 + nDiX;
            var posY:Number = mouseY - nEllipseY / 2 + nDiY;        
            var pixelValue:uint  = bd.getPixel(mouseX + nDiX, mouseY + nDiX);
            nFill = pixelValue;   
            myGraphics.beginFill(nFill); 
            myGraphics.drawEllipse(posX, posY, nEllipseX, nEllipseY);            
            nSinX += nAngle;
            nCosY += nAngle;
            stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDownFunc);
        } 
        
        //キー操作
        private function KeyDownFunc(event:KeyboardEvent):void{
            if(nEllipseX >= 1 && nEllipseY  >= 1 && event.keyCode == Keyboard.UP){
                nEllipseX += 1;
                nEllipseY += 1;
            }
            if(nEllipseX > 1  && nEllipseY >1  && event.keyCode == Keyboard.DOWN){
                  nEllipseX -= 1;
                  nEllipseY -= 1;
            }
            if(nDi >= 1  && event.keyCode == Keyboard.RIGHT){
                 nDi += 1;
             }
             if(nDi > 1 && event.keyCode == Keyboard.LEFT){
                 nDi -= 1;
            }
        } 
        
        //描画終了
        private function xEndEllipse(eventObject:MouseEvent):void{
        myGraphics.endFill();
        stage.removeEventListener(Event.ENTER_FRAME,xDrawEllipse);
        }      
    }    
}