/**
 * Copyright WinField95 ( http://wonderfl.net/user/WinField95 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/irAD
 */

package
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    
    public class Visualizer_Koch_Curve extends Sprite
    {
        
        var startButton:Button;
        var resetButton:Button;
        var tf:TextField;
        
        public function Visualizer_Koch_Curve()
        {    
            
            startButton = new Button("Start",100);
            startButton.x = startButton.y = 0;                    
            startButton.addEventListener(MouseEvent.CLICK, start);
            addChild(startButton);
            
            resetButton = new Button("Reset",100);
            resetButton.x = 0;
            resetButton.y = 30;
            resetButton.addEventListener(MouseEvent.CLICK, reset);
            addChild(resetButton);
            
            tf = new TextField();
            tf.x = 0;
            tf.y = 60;
            tf.defaultTextFormat = new TextFormat("", 12, 0x0, true);
            tf.type = TextFieldType.INPUT;
            tf.border = true;
            tf.borderColor = 0xED1A3D;
            tf.multiline = true;
            addChild(tf);
        }
        
        public function output(array:Array):void{
            
            if(array.length % 2 == 1)return;
            
            var px:Number;
            var py:Number;
            var x:Number;
            var y:Number;
            
            px = Number(array[0])*4.5 + 0;
            py = Number(array[1])*4.5 + 200;

            for(var i:int = 0 ; i < array.length ; i += 2){
                x = Number(array[i])*4.5 + 0;
                y = Number(array[i+1])*4.5 + 200;
                graphics.lineStyle(0.1, 0x0);
                graphics.moveTo(px, py);
                graphics.lineTo(x, y);    
                px = x;
                py = y;
            }
        }
        
        public function parse(str:String):Array{
            var ret:Array = new Array();
            var s:String = new String("");
            for(var i:int = 0 ; i < str.length ; i++){
                if(str.charAt(i) == " " && i != str.length - 1){
                    ret.push(s);
                    s = new String("");
                }
                else s += str.charAt(i);
            }                
            ret.push(s);
            return ret;
        }
        
        public function unifyLineFeedCode(str:String):String {
            var CR:String = String.fromCharCode(13);
            var LF:String = String.fromCharCode(10);
            str = str.split(CR+LF).join(LF);
            str = str.split(CR).join(LF);
            return str;
        }
        
        function lineFeedCodeToBR(str:String):String {
            var CR:String = String.fromCharCode(13);
            var LF:String = String.fromCharCode(10);
            str = str.split(CR+LF).join(LF);
            str = str.split(CR).join(LF);
            str = str.split(LF).join(" ");
            return str;
        }
        
        public function start(event:MouseEvent):void{
            tf.text = lineFeedCodeToBR(tf.text);
            var array:Array = parse(tf.text);
            tf.text = "";
            output(array);
        }
        
        public function reset(event:MouseEvent):void{
            tf.text = "";
            graphics.lineStyle(0.0, 0xFFFFFF);
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(0, 190, 500, 500);
            graphics.endFill();
        }
        
    }
}


import flash.display.*;
import flash.text.*;
class Button extends SimpleButton // ボタンのクラス
{
    public function Button(label:String, width:int = 0):void
    { 
        
        var up:Sprite = _buildImage(label, 0xCCCCCC, width);
        var over:Sprite = _buildImage(label, 0x87CEFA, width);
        var down:Sprite = _buildImage(label, 0x4682B4, width);
        down.y = 1;
        super(up, over, down, up);
    }
    
    public function _buildImage(label:String, color:int, width:int = 0):Sprite
    {
        
        var text:TextField = new TextField();
        text.defaultTextFormat = new TextFormat('Verdana', 10, 0x000000, true, null, null, null, null, TextFormatAlign.CENTER);
        text.autoSize = TextFieldAutoSize.CENTER;
        text.selectable = false;
        text.text = label;
        text.x = (width - text.width) >> 1;
        text.y = 5;
        var base:Shape = new Shape();
        var g:Graphics = base.graphics;
        g.beginFill(color);
        g.drawRect(0, 0, width, text.height + 3);
        g.endFill();
        var sp:Sprite = new Sprite();
        sp.addChild(base);
        sp.addChild(text);
        return sp;
        
    }        
}
