/**
 * Copyright ysissy ( http://wonderfl.net/user/ysissy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iqbd
 */

// forked from clockmaker's Particle Template
package {
    import flash.display.*;
    import flash.events.*;
    import net.hires.debug.Stats; // For FPSTester
    
    public class Main extends Sprite {
        public function Main() {
                       
            // BitmapDataの初期化
            var bmd:BitmapData = new BitmapData(465, 465, false, 0x0);
            var bmp:Bitmap = new Bitmap(bmd);
            addChild(bmp);
            
            //FPSTester Loading
            addChild(new Stats());
              
              
            // パーティクルの作成
            var particles:Array = [];
            for(var i:int=0; i<100000; i++){
                var p:Particle = new Particle();
                p.x = mouseX; // 画面中央の座標を指定
                p.y = mouseY; 
                p.vx = 10 * (Math.random() - 0.5);  // ランダムな速度を指定
                p.vy = 10 * (Math.random() - 0.5);
                p.color = 0xFFFFFF; // 白色を指定
                particles[i] = p;
            }
            
            // アニメーション処理
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            function enterFrameHandler(e:Event):void{
                // リセット (画面を黒く塗りつぶす)
                bmd.fillRect(bmd.rect, 0x000000);
                
                for(var i:int=0; i<particles.length; i++){
                    var p:Particle = particles[i];
                    // 速度を座標に適用
                    p.x += p.vx;
                    p.y += p.vy;
                    // 描画処理
                    bmd.setPixel(p.x, p.y, p.color);
                }
                
            }
          
        }
    }
}

/** パーティクルクラス */
class Particle {
    public var x:Number; // X座標
    public var y:Number; // Y座標
    public var vx:Number; // X軸方向の速さ
    public var vy:Number; // Y軸方向の速さ
    public var color:uint; // 色情報
}


// Mouse INFO
class MouseInfo {
    public var mX : Number; // mouse Coordinate X
    public var mY : Number; // mouse Coordinate Y
    public var mvX : Number; // mouse Velocity X
    public var mvY : Number; // mouse Velocity Y
    
    public function MouseInfo () {
        
        
        
        
        
        
    }
 

    
    
}
